/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus;

import com.baomidou.mybatisplus.MybatisMapperRegistry;
import com.baomidou.mybatisplus.MybatisXMLLanguageDriver;
import com.baomidou.mybatisplus.annotations.FieldStrategy;
import com.baomidou.mybatisplus.mapper.AutoSqlInjector;
import com.baomidou.mybatisplus.mapper.DBType;
import com.baomidou.mybatisplus.mapper.IMetaObjectHandler;
import com.baomidou.mybatisplus.mapper.ISqlInjector;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Logger;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MybatisConfiguration
extends Configuration {
    protected final Logger logger = Logger.getLogger("MybatisConfiguration");
    public static DBType DB_TYPE = DBType.MYSQL;
    public static boolean DB_COLUMN_UNDERLINE = false;
    public static ISqlInjector SQL_INJECTOR = new AutoSqlInjector();
    public final MybatisMapperRegistry mybatisMapperRegistry = new MybatisMapperRegistry(this);
    public static Set<String> MAPPER_REGISTRY_CACHE = new ConcurrentSkipListSet<String>();
    public static IMetaObjectHandler META_OBJECT_HANDLER = null;
    public static FieldStrategy FIELD_STRATEGY = FieldStrategy.NOT_NULL;
    public static boolean IS_REFRESH = false;

    public MybatisConfiguration() {
        System.err.println("mybatis-plus init success.");
    }

    public MybatisConfiguration(Environment environment) {
        super(environment);
    }

    public void addMappedStatement(MappedStatement ms) {
        this.logger.fine(" addMappedStatement: " + ms.getId());
        if (IS_REFRESH) {
            this.mappedStatements.remove(ms.getId());
        } else if (this.mappedStatements.containsKey(ms.getId())) {
            this.logger.severe("mapper[" + ms.getId() + "] is ignored, because it's exists, maybe from xml file");
            return;
        }
        super.addMappedStatement(ms);
    }

    public void setDefaultScriptingLanguage(Class<?> driver) {
        if (driver == null) {
            driver = MybatisXMLLanguageDriver.class;
        }
        super.setDefaultScriptingLanguage(driver);
    }

    public MapperRegistry getMapperRegistry() {
        return this.mybatisMapperRegistry;
    }

    public <T> void addMapper(Class<T> type) {
        this.mybatisMapperRegistry.addMapper(type);
    }

    public void addMappers(String packageName, Class<?> superType) {
        this.mybatisMapperRegistry.addMappers(packageName, superType);
    }

    public void addMappers(String packageName) {
        this.mybatisMapperRegistry.addMappers(packageName);
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        return this.mybatisMapperRegistry.getMapper(type, sqlSession);
    }

    public boolean hasMapper(Class<?> type) {
        return this.mybatisMapperRegistry.hasMapper(type);
    }
}

