/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.activerecord;

import com.baomidou.mybatisplus.activerecord.Record;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.SqlMethod;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.CollectionUtil;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model<T extends Model>
implements Serializable {
    public boolean insert() {
        return this.retBool(this.sqlSession().insert(this.sqlStatement(SqlMethod.INSERT_ONE), (Object)this));
    }

    public boolean insertOrUpdate() {
        if (null != this.getPrimaryKey()) {
            return this.retBool(this.sqlSession().update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), (Object)this));
        }
        return this.retBool(this.sqlSession().insert(this.sqlStatement(SqlMethod.INSERT_ONE), (Object)this));
    }

    public boolean insertSql(String sql) {
        return this.retBool(this.sqlSession().delete(this.sqlStatement("insertSql"), (Object)sql));
    }

    public boolean deleteById(Serializable id) {
        return this.retBool(this.sqlSession().delete(this.sqlStatement(SqlMethod.DELETE_BY_ID), (Object)id));
    }

    public boolean deleteById() {
        return this.deleteById(this.getPrimaryKey());
    }

    public boolean delete(String whereClause, Object ... args) {
        HashMap map = new HashMap();
        EntityWrapper ew = null;
        if (StringUtils.isNotEmpty(whereClause)) {
            ew = new EntityWrapper();
            ew.addFilter(whereClause, args);
        }
        map.put("ew", ew);
        return this.retBool(this.sqlSession().delete(this.sqlStatement(SqlMethod.DELETE), map));
    }

    public boolean deleteSql(String sql) {
        return this.retBool(this.sqlSession().delete(this.sqlStatement("deleteSql"), (Object)sql));
    }

    public boolean updateById() {
        if (null == this.getPrimaryKey()) {
            throw new MybatisPlusException("primaryKey is null.");
        }
        return this.retBool(this.sqlSession().update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), (Object)this));
    }

    public boolean update(String whereClause, Object ... args) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("et", this);
        if (StringUtils.isNotEmpty(whereClause)) {
            EntityWrapper ew = new EntityWrapper();
            ew.addFilter(whereClause, args);
            map.put("ew", ew);
        }
        return this.retBool(this.sqlSession().update(this.sqlStatement(SqlMethod.UPDATE), map));
    }

    public boolean updateSql(String sql) {
        return this.retBool(this.sqlSession().update(this.sqlStatement("updateSql"), (Object)sql));
    }

    public List<T> selectAll() {
        return this.sqlSession().selectList(this.sqlStatement(SqlMethod.SELECT_LIST));
    }

    public T selectById(Serializable id) {
        return (T)((Model)this.sqlSession().selectOne(this.sqlStatement(SqlMethod.SELECT_BY_ID), (Object)id));
    }

    public T selectById() {
        return this.selectById(this.getPrimaryKey());
    }

    public List<T> selectList(String columns, String whereClause, Object ... args) {
        HashMap<String, EntityWrapper<Object>> map = new HashMap<String, EntityWrapper<Object>>();
        EntityWrapper<Object> ew = new EntityWrapper<Object>(null, columns);
        if (StringUtils.isNotEmpty(whereClause)) {
            ew.addFilter(whereClause, args);
        }
        map.put("ew", ew);
        return this.sqlSession().selectList(this.sqlStatement(SqlMethod.SELECT_LIST), map);
    }

    public List<T> selectList(String whereClause, Object ... args) {
        return this.selectList(null, whereClause, args);
    }

    public List<Map<String, Object>> selectListSql(String sql) {
        return this.sqlSession().selectList(this.sqlStatement("selectListSql"), (Object)sql);
    }

    public T selectOne(String columns, String whereClause, Object ... args) {
        List<T> tl = this.selectList(columns, whereClause, args);
        if (CollectionUtil.isEmpty(tl)) {
            return null;
        }
        return (T)((Model)tl.get(0));
    }

    public T selectOne(String whereClause, Object ... args) {
        return this.selectOne(null, whereClause, args);
    }

    public Page<T> selectPage(Page<T> page, String columns, String whereClause, Object ... args) {
        HashMap<String, EntityWrapper<Object>> map = new HashMap<String, EntityWrapper<Object>>();
        EntityWrapper<Object> ew = new EntityWrapper<Object>(null, columns);
        if (StringUtils.isNotEmpty(whereClause)) {
            ew.addFilter(whereClause, args);
        }
        map.put("ew", ew);
        List tl = this.sqlSession().selectList(this.sqlStatement(SqlMethod.SELECT_PAGE), map, page);
        page.setRecords(tl);
        return page;
    }

    public Page<T> selectPage(Page<T> page, String whereClause, Object ... args) {
        return this.selectPage(page, null, whereClause, args);
    }

    List<Map<String, Object>> selectPageSql(Page<T> page, String sql) {
        return this.sqlSession().selectList(this.sqlStatement("selectPageSql"), (Object)sql, page);
    }

    public int selectCount(String whereClause, Object ... args) {
        List<T> tl = this.selectList(whereClause, args);
        if (CollectionUtil.isEmpty(tl)) {
            return 0;
        }
        return tl.size();
    }

    public int selectCount() {
        return this.selectCount(null, new Object[0]);
    }

    private boolean retBool(int result) {
        return result >= 1;
    }

    private SqlSession sqlSession() {
        return Record.sqlSession(this.getClass());
    }

    private String sqlStatement(SqlMethod sqlMethod) {
        return this.sqlStatement(sqlMethod.getMethod());
    }

    private String sqlStatement(String sqlMethod) {
        return Record.table(this.getClass()).getSqlStatement(sqlMethod);
    }

    protected abstract Serializable getPrimaryKey();
}

