/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.mapper.SqlPlus;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Wrapper<T>
implements Serializable {
    protected SqlPlus sql = new SqlPlus();

    public T getEntity() {
        return null;
    }

    public String getSqlSelect() {
        return null;
    }

    public abstract String getSqlSegment();

    public String toString() {
        return this.getSqlSegment();
    }

    public Wrapper<T> where(String sqlWhere, Object ... params) {
        this.sql.WHERE(this.formatSql(sqlWhere, params));
        return this;
    }

    public Wrapper<T> and(String sqlAnd, Object ... params) {
        ((SqlPlus)this.sql.AND()).WHERE(this.formatSql(sqlAnd, params));
        return this;
    }

    public Wrapper<T> andNew(String sqlAnd, Object ... params) {
        ((SqlPlus)this.sql.AND_NEW()).WHERE(this.formatSql(sqlAnd, params));
        return this;
    }

    public Wrapper<T> or(String sqlOr, Object ... params) {
        ((SqlPlus)this.sql.OR()).WHERE(this.formatSql(sqlOr, params));
        return this;
    }

    public Wrapper<T> orNew(String sqlOr, Object ... params) {
        ((SqlPlus)this.sql.OR_NEW()).WHERE(this.formatSql(sqlOr, params));
        return this;
    }

    public Wrapper<T> groupBy(String columns) {
        this.sql.GROUP_BY(columns);
        return this;
    }

    public Wrapper<T> having(String sqlHaving, Object ... params) {
        this.sql.HAVING(this.formatSql(sqlHaving, params));
        return this;
    }

    public Wrapper<T> orderBy(String columns) {
        this.sql.ORDER_BY(columns);
        return this;
    }

    public Wrapper<T> orderBy(String columns, boolean isAsc) {
        if (StringUtils.isNotEmpty(columns)) {
            this.sql.ORDER_BY(columns + (isAsc ? " ASC" : " DESC"));
        }
        return this;
    }

    public Wrapper<T> like(String column, String value) {
        this.sql.LIKE(column, value);
        return this;
    }

    public Wrapper<T> notLike(String column, String value) {
        this.sql.NOT_LIKE(column, value);
        return this;
    }

    public Wrapper<T> isNotNull(String columns) {
        this.sql.IS_NOT_NULL(columns);
        return this;
    }

    public Wrapper<T> isNull(String columns) {
        this.sql.IS_NULL(columns);
        return this;
    }

    public Wrapper<T> exists(String value) {
        this.sql.EXISTS(value);
        return this;
    }

    public Wrapper<T> notExists(String value) {
        this.sql.NOT_EXISTS(value);
        return this;
    }

    public Wrapper<T> in(String column, String value) {
        this.sql.IN(column, value);
        return this;
    }

    public Wrapper<T> notIn(String column, String value) {
        this.sql.NOT_IN(column, value);
        return this;
    }

    public Wrapper<T> in(String column, Collection<?> value) {
        this.sql.IN(column, value);
        return this;
    }

    public Wrapper<T> notIn(String column, Collection<?> value) {
        this.sql.NOT_IN(column, value);
        return this;
    }

    public Wrapper<T> in(String column, Object[] value) {
        this.sql.IN(column, Arrays.asList(value));
        return this;
    }

    public Wrapper<T> notIn(String column, Object ... value) {
        this.sql.NOT_IN(column, Arrays.asList(value));
        return this;
    }

    public Wrapper<T> between(String column, String val1, String val2) {
        this.sql.BETWEEN_AND(column, val1, val2);
        return this;
    }

    public Wrapper<T> addFilter(String sqlWhere, Object ... params) {
        return this.and(sqlWhere, params);
    }

    public Wrapper<T> addFilterIfNeed(boolean need, String sqlWhere, Object ... params) {
        return need ? this.where(sqlWhere, params) : this;
    }

    protected String stripSqlInjection(String value) {
        return value.replaceAll("('.+--)|(--)|(\\|)|(%7C)", "");
    }

    protected String formatSql(String sqlStr, Object ... params) {
        return this.formatSqlIfNeed(true, sqlStr, params);
    }

    protected String formatSqlIfNeed(boolean need, String sqlStr, Object ... params) {
        if (!need || StringUtils.isEmpty(sqlStr)) {
            return null;
        }
        return StringUtils.sqlArgsFill(sqlStr, params);
    }
}

