/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.MybatisConfiguration;
import com.baomidou.mybatisplus.annotations.FieldStrategy;
import com.baomidou.mybatisplus.toolkit.SqlReservedWords;
import com.baomidou.mybatisplus.toolkit.StringUtils;

public class TableFieldInfo {
    private boolean related;
    private String column;
    private String property;
    private String el;
    private FieldStrategy fieldStrategy = FieldStrategy.NOT_NULL;

    public TableFieldInfo(String column, String property, String el, FieldStrategy fieldStrategy) {
        if (MybatisConfiguration.DB_COLUMN_UNDERLINE) {
            this.related = true;
            this.setColumn(StringUtils.camelToUnderline(column));
        } else if (!column.equals(property)) {
            this.related = true;
            this.setColumn(column);
        } else {
            this.related = false;
            this.setColumn(column);
        }
        this.property = property;
        this.el = el;
        this.fieldStrategy = fieldStrategy != FieldStrategy.NOT_NULL ? fieldStrategy : MybatisConfiguration.FIELD_STRATEGY;
    }

    public TableFieldInfo(String column) {
        if (MybatisConfiguration.DB_COLUMN_UNDERLINE) {
            this.related = true;
            this.setColumn(StringUtils.camelToUnderline(column));
        } else {
            this.related = false;
            this.setColumn(column);
        }
        this.property = column;
        this.el = column;
        this.fieldStrategy = MybatisConfiguration.FIELD_STRATEGY;
    }

    public boolean isRelated() {
        return this.related;
    }

    public void setRelated(boolean related) {
        this.related = related;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = SqlReservedWords.convert(column);
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getEl() {
        return this.el;
    }

    public void setEl(String el) {
        this.el = el;
    }

    public FieldStrategy getFieldStrategy() {
        return this.fieldStrategy;
    }

    public void setFieldStrategy(FieldStrategy fieldStrategy) {
        this.fieldStrategy = fieldStrategy;
    }
}

