/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.MybatisConfiguration;
import com.baomidou.mybatisplus.MybatisPlusHolder;
import com.baomidou.mybatisplus.annotations.FieldStrategy;
import com.baomidou.mybatisplus.annotations.IdType;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.baomidou.mybatisplus.toolkit.TableFieldInfo;
import com.baomidou.mybatisplus.toolkit.TableInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.session.SqlSessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInfoHelper {
    protected static final Logger logger = Logger.getLogger("TableInfoHelper");
    private static final Map<String, TableInfo> tableInfoCache = new ConcurrentHashMap<String, TableInfo>();
    private static final String DEFAULT_ID_NAME = "id";

    public static TableInfo getTableInfo(Class<?> clazz) {
        return tableInfoCache.get(clazz.getName());
    }

    public static synchronized TableInfo initTableInfo(MapperBuilderAssistant builderAssistant, Class<?> clazz) {
        TableInfo ti = tableInfoCache.get(clazz.getName());
        if (ti != null) {
            return ti;
        }
        TableInfo tableInfo = new TableInfo();
        if (null != builderAssistant) {
            tableInfo.setCurrentNamespace(builderAssistant.getCurrentNamespace());
        }
        TableName table = clazz.getAnnotation(TableName.class);
        String tableName = clazz.getSimpleName();
        tableName = table != null && StringUtils.isNotEmpty(table.value()) ? table.value() : (MybatisConfiguration.DB_COLUMN_UNDERLINE ? StringUtils.camelToUnderline(tableName) : tableName.toLowerCase());
        tableInfo.setTableName(tableName);
        if (table != null && StringUtils.isNotEmpty(table.resultMap())) {
            tableInfo.setResultMap(table.resultMap());
        }
        ArrayList<TableFieldInfo> fieldList = new ArrayList<TableFieldInfo>();
        List<Field> list = TableInfoHelper.getAllFields(clazz);
        boolean existTableId = TableInfoHelper.existTableId(list);
        for (Field field : list) {
            if ((!existTableId ? TableInfoHelper.initFieldId(tableInfo, field, clazz) : TableInfoHelper.initTableId(tableInfo, field, clazz)) || TableInfoHelper.initTableField(fieldList, field, clazz)) continue;
            TableFieldInfo tfi = new TableFieldInfo(field.getName());
            if (Date.class.isAssignableFrom(field.getType())) {
                tfi.setFieldStrategy(FieldStrategy.NOT_NULL);
            }
            fieldList.add(tfi);
        }
        tableInfo.setFieldList(fieldList);
        if (null != MybatisPlusHolder.getSqlSessionFactory()) {
            tableInfo.setSqlSessionFactory(MybatisPlusHolder.getSqlSessionFactory());
        }
        if (null == tableInfo.getKeyColumn()) {
            logger.warning(String.format("Warn: Could not find @TableId in Class: %s, initTableInfo Method Fail.", clazz.getName()));
            return null;
        }
        tableInfoCache.put(clazz.getName(), tableInfo);
        return tableInfo;
    }

    public static boolean existTableId(List<Field> list) {
        boolean exist = false;
        for (Field field : list) {
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableId == null) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private static boolean initTableId(TableInfo tableInfo, Field field, Class<?> clazz) {
        TableId tableId = field.getAnnotation(TableId.class);
        if (tableId != null) {
            if (tableInfo.getKeyColumn() == null) {
                tableInfo.setIdType(tableId.type());
                if (StringUtils.isNotEmpty(tableId.value())) {
                    tableInfo.setKeyColumn(tableId.value());
                    tableInfo.setKeyRelated(true);
                } else if (MybatisConfiguration.DB_COLUMN_UNDERLINE) {
                    tableInfo.setKeyColumn(StringUtils.camelToUnderline(field.getName()));
                } else {
                    tableInfo.setKeyColumn(field.getName());
                }
                tableInfo.setKeyProperty(field.getName());
                return true;
            }
            TableInfoHelper.throwExceptionId(clazz);
        }
        return false;
    }

    private static boolean initFieldId(TableInfo tableInfo, Field field, Class<?> clazz) {
        if (DEFAULT_ID_NAME.equals(field.getName())) {
            if (tableInfo.getKeyColumn() == null) {
                tableInfo.setIdType(IdType.ID_WORKER);
                tableInfo.setKeyColumn(field.getName());
                tableInfo.setKeyProperty(field.getName());
                return true;
            }
            TableInfoHelper.throwExceptionId(clazz);
        }
        return false;
    }

    private static void throwExceptionId(Class<?> clazz) {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("There must be only one, Discover multiple @TableId annotation in ");
        errorMsg.append(clazz.getName());
        throw new MybatisPlusException(errorMsg.toString());
    }

    private static boolean initTableField(List<TableFieldInfo> fieldList, Field field, Class<?> clazz) {
        TableField tableField = field.getAnnotation(TableField.class);
        if (tableField != null) {
            String columnName = field.getName();
            if (StringUtils.isNotEmpty(tableField.value())) {
                columnName = tableField.value();
            }
            String el = field.getName();
            if (StringUtils.isNotEmpty(tableField.el())) {
                el = tableField.el();
            }
            String[] columns = columnName.split(";");
            String[] els = el.split(";");
            if (null != columns && null != els && columns.length == els.length) {
                for (int i = 0; i < columns.length; ++i) {
                    fieldList.add(new TableFieldInfo(columns[i], field.getName(), els[i], tableField.validate()));
                }
            } else {
                String errorMsg = "Class: %s, Field: %s, 'value' 'el' Length must be consistent.";
                throw new MybatisPlusException(String.format(errorMsg, clazz.getName(), field.getName()));
            }
            return true;
        }
        return false;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        Field[] fields;
        LinkedList<Field> result = new LinkedList<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            TableField tableField;
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || (tableField = field.getAnnotation(TableField.class)) != null && !tableField.exist()) continue;
            result.add(field);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return result;
        }
        result.addAll(TableInfoHelper.getAllFields(superClass));
        return result;
    }

    public static void initSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        for (TableInfo tableInfo : tableInfoCache.values()) {
            if (null != tableInfo.getSqlSessionFactory()) continue;
            tableInfo.setSqlSessionFactory(sqlSessionFactory);
        }
    }
}

