/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.DbType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.config.rules.QuerySQL;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ConfigBuilder {
    private Connection connection;
    private QuerySQL querySQL;
    private String superEntityClass;
    private String superMapperClass;
    private String superServiceClass;
    private String superServiceImplClass;
    private String superControllerClass;
    private List<TableInfo> tableInfoList;
    private Map<String, String> packageInfo;
    private Map<String, String> pathInfo;
    private TemplateConfig template;
    private DataSourceConfig dataSourceConfig;
    private StrategyConfig strategyConfig;
    private GlobalConfig globalConfig;

    public ConfigBuilder(PackageConfig packageConfig, DataSourceConfig dataSourceConfig, StrategyConfig strategyConfig, TemplateConfig template, GlobalConfig globalConfig) {
        this.globalConfig = null == globalConfig ? new GlobalConfig() : globalConfig;
        this.template = null == template ? new TemplateConfig() : template;
        if (null == packageConfig) {
            this.handlerPackage(this.template, this.globalConfig.getOutputDir(), new PackageConfig());
        } else {
            this.handlerPackage(this.template, this.globalConfig.getOutputDir(), packageConfig);
        }
        this.dataSourceConfig = dataSourceConfig;
        this.handlerDataSource(dataSourceConfig);
        this.strategyConfig = null == strategyConfig ? new StrategyConfig() : strategyConfig;
        this.handlerStrategy(this.strategyConfig);
    }

    public Map<String, String> getPackageInfo() {
        return this.packageInfo;
    }

    public Map<String, String> getPathInfo() {
        return this.pathInfo;
    }

    public String getSuperEntityClass() {
        return this.superEntityClass;
    }

    public String getSuperMapperClass() {
        return this.superMapperClass;
    }

    public String getSuperServiceClass() {
        return this.superServiceClass;
    }

    public String getSuperServiceImplClass() {
        return this.superServiceImplClass;
    }

    public String getSuperControllerClass() {
        return this.superControllerClass;
    }

    public List<TableInfo> getTableInfoList() {
        return this.tableInfoList;
    }

    public TemplateConfig getTemplate() {
        return this.template == null ? new TemplateConfig() : this.template;
    }

    private void handlerPackage(TemplateConfig template, String outputDir, PackageConfig config) {
        this.packageInfo = new HashMap<String, String>();
        this.packageInfo.put("ModuleName", config.getModuleName());
        this.packageInfo.put("Entity", this.joinPackage(config.getParent(), config.getEntity()));
        this.packageInfo.put("Mapper", this.joinPackage(config.getParent(), config.getMapper()));
        this.packageInfo.put("Xml", this.joinPackage(config.getParent(), config.getXml()));
        this.packageInfo.put("Service", this.joinPackage(config.getParent(), config.getService()));
        this.packageInfo.put("ServiceImpl", this.joinPackage(config.getParent(), config.getServiceImpl()));
        this.packageInfo.put("Controller", this.joinPackage(config.getParent(), config.getController()));
        this.pathInfo = new HashMap<String, String>();
        if (StringUtils.isNotEmpty(template.getEntity())) {
            this.pathInfo.put("entity_path", this.joinPath(outputDir, this.packageInfo.get("Entity")));
        }
        if (StringUtils.isNotEmpty(template.getMapper())) {
            this.pathInfo.put("mapper_path", this.joinPath(outputDir, this.packageInfo.get("Mapper")));
        }
        if (StringUtils.isNotEmpty(template.getXml())) {
            this.pathInfo.put("xml_path", this.joinPath(outputDir, this.packageInfo.get("Xml")));
        }
        if (StringUtils.isNotEmpty(template.getService())) {
            this.pathInfo.put("serivce_path", this.joinPath(outputDir, this.packageInfo.get("Service")));
        }
        if (StringUtils.isNotEmpty(template.getServiceImpl())) {
            this.pathInfo.put("serviceimpl_path", this.joinPath(outputDir, this.packageInfo.get("ServiceImpl")));
        }
        if (StringUtils.isNotEmpty(template.getController())) {
            this.pathInfo.put("controller_path", this.joinPath(outputDir, this.packageInfo.get("Controller")));
        }
    }

    private void handlerDataSource(DataSourceConfig config) {
        this.connection = config.getConn();
        this.querySQL = this.getQuerySQL(config.getDbType());
    }

    private void handlerStrategy(StrategyConfig config) {
        this.processTypes(config);
        this.tableInfoList = this.getTablesInfo(config);
    }

    private void processTypes(StrategyConfig config) {
        this.superServiceClass = StringUtils.isEmpty(config.getSuperServiceClass()) ? "com.baomidou.mybatisplus.service.IService" : config.getSuperServiceClass();
        this.superServiceImplClass = StringUtils.isEmpty(config.getSuperServiceImplClass()) ? "com.baomidou.mybatisplus.service.impl.ServiceImpl" : config.getSuperServiceImplClass();
        this.superMapperClass = StringUtils.isEmpty(config.getSuperMapperClass()) ? "com.baomidou.mybatisplus.mapper.BaseMapper" : config.getSuperMapperClass();
        this.superEntityClass = config.getSuperEntityClass();
        this.superControllerClass = config.getSuperControllerClass();
    }

    private List<TableInfo> processTable(List<TableInfo> tableList, NamingStrategy strategy, String[] tablePrefix) {
        for (TableInfo tableInfo : tableList) {
            tableInfo.setEntityName(this.strategyConfig, NamingStrategy.capitalFirst(this.processName(tableInfo.getName(), strategy, tablePrefix)));
            if (StringUtils.isNotEmpty(this.globalConfig.getMapperName())) {
                tableInfo.setMapperName(String.format(this.globalConfig.getMapperName(), tableInfo.getEntityName()));
            } else {
                tableInfo.setMapperName(tableInfo.getEntityName() + "Mapper");
            }
            if (StringUtils.isNotEmpty(this.globalConfig.getXmlName())) {
                tableInfo.setXmlName(String.format(this.globalConfig.getXmlName(), tableInfo.getEntityName()));
            } else {
                tableInfo.setXmlName(tableInfo.getEntityName() + "Mapper");
            }
            if (StringUtils.isNotEmpty(this.globalConfig.getServiceName())) {
                tableInfo.setServiceName(String.format(this.globalConfig.getServiceName(), tableInfo.getEntityName()));
            } else {
                tableInfo.setServiceName("I" + tableInfo.getEntityName() + "Service");
            }
            if (StringUtils.isNotEmpty(this.globalConfig.getServiceImplName())) {
                tableInfo.setServiceImplName(String.format(this.globalConfig.getServiceImplName(), tableInfo.getEntityName()));
            } else {
                tableInfo.setServiceImplName(tableInfo.getEntityName() + "ServiceImpl");
            }
            if (StringUtils.isNotEmpty(this.globalConfig.getControllerName())) {
                tableInfo.setControllerName(String.format(this.globalConfig.getControllerName(), tableInfo.getEntityName()));
                continue;
            }
            tableInfo.setControllerName(tableInfo.getEntityName() + "Controller");
        }
        return tableList;
    }

    private List<TableInfo> getTablesInfo(StrategyConfig config) {
        boolean isExclude;
        boolean isInclude = null != config.getInclude() && config.getInclude().length > 0;
        boolean bl = isExclude = null != config.getExclude() && config.getExclude().length > 0;
        if (isInclude && isExclude) {
            throw new RuntimeException("<strategy> \u6807\u7b7e\u4e2d <include> \u4e0e <exclude> \u53ea\u80fd\u914d\u7f6e\u4e00\u9879\uff01");
        }
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        HashSet<String> notExistTables = new HashSet<String>();
        NamingStrategy strategy = config.getNaming();
        try (PreparedStatement prepareStatement = this.connection.prepareStatement(this.querySQL.getTableCommentsSql());
             ResultSet results = prepareStatement.executeQuery();){
            while (results.next()) {
                String tableName = results.getString(this.querySQL.getTableName());
                if (StringUtils.isNotEmpty(tableName)) {
                    String tableComment = results.getString(this.querySQL.getTableComment());
                    TableInfo tableInfo = new TableInfo();
                    if (isInclude) {
                        for (String includeTab : config.getInclude()) {
                            if (includeTab.equalsIgnoreCase(tableName)) {
                                tableInfo.setName(tableName);
                                tableInfo.setComment(tableComment);
                                continue;
                            }
                            notExistTables.add(includeTab);
                        }
                    } else if (isExclude) {
                        for (String excludeTab : config.getExclude()) {
                            if (!excludeTab.equalsIgnoreCase(tableName)) {
                                tableInfo.setName(tableName);
                                tableInfo.setComment(tableComment);
                                continue;
                            }
                            notExistTables.add(excludeTab);
                        }
                    } else {
                        tableInfo.setName(tableName);
                        tableInfo.setComment(tableComment);
                    }
                    if (!StringUtils.isNotEmpty(tableInfo.getName())) continue;
                    List<TableField> fieldList = this.getListFields(tableInfo.getName(), strategy);
                    tableInfo.setFields(fieldList);
                    tableList.add(tableInfo);
                    continue;
                }
                System.err.println("\u5f53\u524d\u6570\u636e\u5e93\u4e3a\u7a7a\uff01\uff01\uff01");
            }
            for (TableInfo tabInfo : tableList) {
                notExistTables.remove(tabInfo.getName());
            }
            if (notExistTables.size() > 0) {
                System.err.println("\u8868 " + notExistTables + " \u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.processTable(tableList, strategy, config.getTablePrefix());
    }

    private boolean isKeyIdentity(ResultSet results) throws SQLException {
        String extra;
        return QuerySQL.MYSQL == this.querySQL && "auto_increment".equals(extra = results.getString("Extra"));
    }

    private List<TableField> getListFields(String tableName, NamingStrategy strategy) {
        boolean haveId = false;
        ArrayList<TableField> fieldList = new ArrayList<TableField>();
        try (PreparedStatement pstate = this.connection.prepareStatement(String.format(this.querySQL.getTableFieldsSql(), tableName));
             ResultSet results = pstate.executeQuery();){
            while (results.next()) {
                boolean isId;
                TableField field = new TableField();
                String key = results.getString(this.querySQL.getFieldKey());
                boolean bl = isId = StringUtils.isNotEmpty(key) && key.toUpperCase().equals("PRI");
                if (isId && !haveId) {
                    field.setKeyFlag(true);
                    if (this.isKeyIdentity(results)) {
                        field.setKeyIdentityFlag(true);
                    }
                    haveId = true;
                } else {
                    field.setKeyFlag(false);
                }
                field.setName(results.getString(this.querySQL.getFieldName()));
                if (this.strategyConfig.includeSuperEntityColumns(field.getName())) continue;
                field.setType(results.getString(this.querySQL.getFieldType()));
                field.setPropertyName(this.strategyConfig, this.processName(field.getName(), strategy));
                field.setColumnType(this.dataSourceConfig.getTypeConvert().processTypeConvert(field.getType()));
                field.setComment(results.getString(this.querySQL.getFieldComment()));
                fieldList.add(field);
            }
        }
        catch (SQLException e) {
            System.err.println("SQL Exception\uff1a" + e.getMessage());
        }
        return fieldList;
    }

    private String joinPath(String parentDir, String packageName) {
        if (StringUtils.isEmpty(parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith(parentDir, File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private String joinPackage(String parent, String subPackage) {
        if (StringUtils.isEmpty(parent)) {
            return subPackage;
        }
        return parent + "." + subPackage;
    }

    private String processName(String name, NamingStrategy strategy) {
        return this.processName(name, strategy, null);
    }

    private String processName(String name, NamingStrategy strategy, String[] tablePrefix) {
        boolean removePrefix = false;
        if (tablePrefix != null && tablePrefix.length >= 1) {
            removePrefix = true;
        }
        String propertyName = removePrefix ? (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.removePrefixAndCamel(name, tablePrefix) : NamingStrategy.removePrefix(name, tablePrefix)) : (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.underlineToCamel(name) : name);
        return propertyName;
    }

    private QuerySQL getQuerySQL(DbType dbType) {
        for (QuerySQL qs : QuerySQL.values()) {
            if (!qs.getDbType().equals(dbType.getValue())) continue;
            return qs;
        }
        return QuerySQL.MYSQL;
    }

    public StrategyConfig getStrategyConfig() {
        return this.strategyConfig;
    }

    public void setStrategyConfig(StrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }
}

