/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.entity.TableInfo;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.util.List;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class SqlHelper {
    private static final Log logger = LogFactory.getLog(SqlHelper.class);

    public static SqlSession sqlSession(Class<?> clazz) {
        return SqlHelper.sqlSession(clazz, true);
    }

    public static SqlSession sqlSessionBatch(Class<?> clazz) {
        return GlobalConfiguration.currentSessionFactory(clazz).openSession(ExecutorType.BATCH);
    }

    private static SqlSession getSqlSession(Class<?> clazz) {
        SqlSession session = null;
        try {
            SqlSessionFactory sqlSessionFactory = GlobalConfiguration.currentSessionFactory(clazz);
            Configuration configuration = sqlSessionFactory.getConfiguration();
            session = GlobalConfiguration.getGlobalConfig(configuration).getSqlSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return session;
    }

    public static SqlSession sqlSession(Class<?> clazz, boolean autoCommit) {
        SqlSession sqlSession = SqlHelper.getSqlSession(clazz);
        return sqlSession != null ? sqlSession : GlobalConfiguration.currentSessionFactory(clazz).openSession(autoCommit);
    }

    public static TableInfo table(Class<?> clazz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        if (null == tableInfo) {
            throw new MybatisPlusException("Error: Cannot execute table Method, ClassGenricType not found .");
        }
        return tableInfo;
    }

    public static boolean retBool(Integer result) {
        return null != result && result >= 1;
    }

    public static int retCount(Integer result) {
        return null == result ? 0 : result;
    }

    public static <E> E getObject(List<E> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                logger.warn(String.format("Warn: execute Method There are  %s results.", size));
            }
            return list.get(0);
        }
        return null;
    }

    public static void fillWrapper(Page<?> page, Wrapper<?> wrapper) {
        if (null == page) {
            return;
        }
        if (SqlHelper.isWrapperEmpty(wrapper)) {
            if (page.isOpenSort()) {
                wrapper.orderBy(page.getOrderByField(), page.isAsc());
            }
            wrapper.allEq(page.getCondition());
        }
    }

    public static boolean isWrapperEmpty(Wrapper<?> wrapper) {
        return null == wrapper || Condition.EMPTY.equals(wrapper);
    }

    public static boolean isWrapperNotEmpty(Wrapper<?> wrapper) {
        return !SqlHelper.isWrapperEmpty(wrapper);
    }
}

