/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitm;

import com.browserup.bup.mitm.CertificateAndKey;
import com.browserup.bup.mitm.CertificateAndKeySource;
import com.browserup.bup.mitm.CertificateInfo;
import com.browserup.bup.mitm.keys.KeyGenerator;
import com.browserup.bup.mitm.keys.RSAKeyGenerator;
import com.browserup.bup.mitm.tools.DefaultSecurityProviderTool;
import com.browserup.bup.mitm.tools.SecurityProviderTool;
import com.browserup.bup.mitm.util.EncryptionUtil;
import com.browserup.bup.mitm.util.MitmConstants;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootCertificateGenerator
implements CertificateAndKeySource {
    private static final Logger log = LoggerFactory.getLogger(RootCertificateGenerator.class);
    private final CertificateInfo rootCertificateInfo;
    private final String messageDigest;
    private final KeyGenerator keyGenerator;
    private final SecurityProviderTool securityProviderTool;
    private static final String DEFAULT_PEM_ENCRYPTION_ALGORITHM = "AES-128-CBC";
    private final Supplier<CertificateAndKey> generatedCertificateAndKey = Suppliers.memoize(this::generateRootCertificate);

    public RootCertificateGenerator(CertificateInfo rootCertificateInfo, String messageDigest, KeyGenerator keyGenerator, SecurityProviderTool securityProviderTool) {
        if (rootCertificateInfo == null) {
            throw new IllegalArgumentException("CA root certificate cannot be null");
        }
        if (messageDigest == null) {
            throw new IllegalArgumentException("Message digest cannot be null");
        }
        if (keyGenerator == null) {
            throw new IllegalArgumentException("Key generator cannot be null");
        }
        if (securityProviderTool == null) {
            throw new IllegalArgumentException("Certificate tool cannot be null");
        }
        this.rootCertificateInfo = rootCertificateInfo;
        this.messageDigest = messageDigest;
        this.keyGenerator = keyGenerator;
        this.securityProviderTool = securityProviderTool;
    }

    @Override
    public CertificateAndKey load() {
        return (CertificateAndKey)this.generatedCertificateAndKey.get();
    }

    private CertificateAndKey generateRootCertificate() {
        long generationStart = System.currentTimeMillis();
        KeyPair caKeyPair = this.keyGenerator.generate();
        CertificateAndKey certificateAndKey = this.securityProviderTool.createCARootCertificate(this.rootCertificateInfo, caKeyPair, this.messageDigest);
        long generationFinished = System.currentTimeMillis();
        log.info("Generated CA root certificate and private key in {}ms. Key generator: {}. Signature algorithm: {}.", new Object[]{generationFinished - generationStart, this.keyGenerator, this.messageDigest});
        return certificateAndKey;
    }

    public String encodeRootCertificateAsPem() {
        return this.securityProviderTool.encodeCertificateAsPem(((CertificateAndKey)this.generatedCertificateAndKey.get()).getCertificate());
    }

    public String encodePrivateKeyAsPem(String privateKeyPassword) {
        return this.securityProviderTool.encodePrivateKeyAsPem(((CertificateAndKey)this.generatedCertificateAndKey.get()).getPrivateKey(), privateKeyPassword, DEFAULT_PEM_ENCRYPTION_ALGORITHM);
    }

    public void saveRootCertificateAsPemFile(File file) {
        String pemEncodedCertificate = this.securityProviderTool.encodeCertificateAsPem(((CertificateAndKey)this.generatedCertificateAndKey.get()).getCertificate());
        EncryptionUtil.writePemStringToFile(file, pemEncodedCertificate);
    }

    public void savePrivateKeyAsPemFile(File file, String passwordForPrivateKey) {
        String pemEncodedPrivateKey = this.securityProviderTool.encodePrivateKeyAsPem(((CertificateAndKey)this.generatedCertificateAndKey.get()).getPrivateKey(), passwordForPrivateKey, DEFAULT_PEM_ENCRYPTION_ALGORITHM);
        EncryptionUtil.writePemStringToFile(file, pemEncodedPrivateKey);
    }

    public void saveRootCertificateAndKey(String keyStoreType, File file, String privateKeyAlias, String password) {
        CertificateAndKey certificateAndKey = (CertificateAndKey)this.generatedCertificateAndKey.get();
        KeyStore keyStore = this.securityProviderTool.createRootCertificateKeyStore(keyStoreType, certificateAndKey, privateKeyAlias, password);
        this.securityProviderTool.saveKeyStore(file, keyStore, password);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String getDefaultCommonName() {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "localhost";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz");
        String currentDateTime = dateFormat.format(new Date());
        String defaultCN = "Generated CA (" + hostname + ") " + currentDateTime;
        return defaultCN.length() <= 64 ? defaultCN : defaultCN.substring(0, 63);
    }

    static /* synthetic */ String access$000() {
        return RootCertificateGenerator.getDefaultCommonName();
    }

    public static class Builder {
        private CertificateInfo certificateInfo = new CertificateInfo().commonName(RootCertificateGenerator.access$000()).organization("CA dynamically generated by LittleProxy").notBefore(ZonedDateTime.now().minusYears(1L).toInstant()).notAfter(ZonedDateTime.now().plusYears(1L).toInstant());
        private KeyGenerator keyGenerator = new RSAKeyGenerator();
        private String messageDigest = MitmConstants.DEFAULT_MESSAGE_DIGEST;
        private SecurityProviderTool securityProviderTool = new DefaultSecurityProviderTool();

        public Builder certificateInfo(CertificateInfo certificateInfo) {
            this.certificateInfo = certificateInfo;
            return this;
        }

        public Builder keyGenerator(KeyGenerator keyGenerator) {
            this.keyGenerator = keyGenerator;
            return this;
        }

        public Builder messageDigest(String messageDigest) {
            this.messageDigest = messageDigest;
            return this;
        }

        public Builder certificateTool(SecurityProviderTool securityProviderTool) {
            this.securityProviderTool = securityProviderTool;
            return this;
        }

        public RootCertificateGenerator build() {
            return new RootCertificateGenerator(this.certificateInfo, this.messageDigest, this.keyGenerator, this.securityProviderTool);
        }
    }
}

