/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitm.tools;

import com.browserup.bup.mitm.CertificateAndKey;
import com.browserup.bup.mitm.CertificateInfo;
import com.browserup.bup.mitm.exception.CertificateCreationException;
import com.browserup.bup.mitm.exception.ExportException;
import com.browserup.bup.mitm.exception.ImportException;
import com.browserup.bup.mitm.tools.SecurityProviderTool;
import com.browserup.bup.mitm.util.EncryptionUtil;
import com.google.common.net.InetAddresses;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.net.ssl.KeyManager;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class BouncyCastleSecurityProviderTool
implements SecurityProviderTool {
    private static final int CERTIFICATE_SERIAL_NUMBER_SIZE = 160;

    @Override
    public CertificateAndKey createServerCertificate(CertificateInfo certificateInfo, X509Certificate caRootCertificate, PrivateKey caPrivateKey, KeyPair serverKeyPair, String messageDigest) {
        X509CertificateHolder certificateHolder;
        if (certificateInfo.getCommonName() == null) {
            throw new IllegalArgumentException("Must specify CN for server certificate");
        }
        if (certificateInfo.getNotBefore() == null) {
            throw new IllegalArgumentException("Must specify Not Before for server certificate");
        }
        if (certificateInfo.getNotAfter() == null) {
            throw new IllegalArgumentException("Must specify Not After for server certificate");
        }
        X500Name serverCertificateSubject = BouncyCastleSecurityProviderTool.createX500NameForCertificate(certificateInfo);
        String signatureAlgorithm = EncryptionUtil.getSignatureAlgorithm(messageDigest, caPrivateKey);
        ContentSigner signer = BouncyCastleSecurityProviderTool.getCertificateSigner(caPrivateKey, signatureAlgorithm);
        BigInteger serialNumber = EncryptionUtil.getRandomBigInteger(160);
        try {
            certificateHolder = new JcaX509v3CertificateBuilder(caRootCertificate, serialNumber, Date.from(certificateInfo.getNotBefore()), Date.from(certificateInfo.getNotAfter()), serverCertificateSubject, serverKeyPair.getPublic()).addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)BouncyCastleSecurityProviderTool.getDomainNameSANsAsASN1Encodable(certificateInfo.getSubjectAlternativeNames())).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)BouncyCastleSecurityProviderTool.createSubjectKeyIdentifier(serverKeyPair.getPublic())).addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false)).build(signer);
        }
        catch (CertIOException e) {
            throw new CertificateCreationException("Error creating new server certificate", e);
        }
        X509Certificate serverCertificate = BouncyCastleSecurityProviderTool.convertToJcaCertificate(certificateHolder);
        return new CertificateAndKey(serverCertificate, serverKeyPair.getPrivate());
    }

    @Override
    public KeyStore createServerKeyStore(String keyStoreType, CertificateAndKey serverCertificateAndKey, X509Certificate rootCertificate, String privateKeyAlias, String password) {
        throw new UnsupportedOperationException("BouncyCastle implementation does not implement this method");
    }

    @Override
    public KeyStore createRootCertificateKeyStore(String keyStoreType, CertificateAndKey rootCertificateAndKey, String privateKeyAlias, String password) {
        throw new UnsupportedOperationException("BouncyCastle implementation does not implement this method");
    }

    @Override
    public CertificateAndKey createCARootCertificate(CertificateInfo certificateInfo, KeyPair keyPair, String messageDigest) {
        X509CertificateHolder certificateHolder;
        if (certificateInfo.getNotBefore() == null) {
            throw new IllegalArgumentException("Must specify Not Before for server certificate");
        }
        if (certificateInfo.getNotAfter() == null) {
            throw new IllegalArgumentException("Must specify Not After for server certificate");
        }
        X500Name issuer = BouncyCastleSecurityProviderTool.createX500NameForCertificate(certificateInfo);
        BigInteger serial = EncryptionUtil.getRandomBigInteger(160);
        PublicKey rootCertificatePublicKey = keyPair.getPublic();
        String signatureAlgorithm = EncryptionUtil.getSignatureAlgorithm(messageDigest, keyPair.getPrivate());
        ContentSigner selfSigner = BouncyCastleSecurityProviderTool.getCertificateSigner(keyPair.getPrivate(), signatureAlgorithm);
        ASN1EncodableVector extendedKeyUsages = new ASN1EncodableVector();
        extendedKeyUsages.add((ASN1Encodable)KeyPurposeId.id_kp_serverAuth);
        extendedKeyUsages.add((ASN1Encodable)KeyPurposeId.id_kp_clientAuth);
        extendedKeyUsages.add((ASN1Encodable)KeyPurposeId.anyExtendedKeyUsage);
        try {
            certificateHolder = new JcaX509v3CertificateBuilder(issuer, serial, Date.from(certificateInfo.getNotBefore()), Date.from(certificateInfo.getNotAfter()), issuer, rootCertificatePublicKey).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)BouncyCastleSecurityProviderTool.createSubjectKeyIdentifier(rootCertificatePublicKey)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true)).addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(182)).addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new DERSequence(extendedKeyUsages)).build(selfSigner);
        }
        catch (CertIOException e) {
            throw new CertificateCreationException("Error creating root certificate", e);
        }
        X509Certificate cert = BouncyCastleSecurityProviderTool.convertToJcaCertificate(certificateHolder);
        return new CertificateAndKey(cert, keyPair.getPrivate());
    }

    @Override
    public String encodePrivateKeyAsPem(PrivateKey privateKey, String passwordForPrivateKey, String encryptionAlgorithm) {
        if (passwordForPrivateKey == null) {
            throw new IllegalArgumentException("You must specify a password when serializing a private key");
        }
        PEMEncryptor encryptor = new JcePEMEncryptorBuilder(encryptionAlgorithm).build(passwordForPrivateKey.toCharArray());
        return BouncyCastleSecurityProviderTool.encodeObjectAsPemString(privateKey, encryptor);
    }

    @Override
    public String encodeCertificateAsPem(Certificate certificate) {
        return BouncyCastleSecurityProviderTool.encodeObjectAsPemString(certificate, null);
    }

    @Override
    public PrivateKey decodePemEncodedPrivateKey(Reader privateKeyReader, String password) {
        PrivateKey privateKey;
        PEMParser pemParser = new PEMParser(privateKeyReader);
        try {
            PrivateKeyInfo keyInfo;
            Object keyPair = pemParser.readObject();
            if (keyPair instanceof PEMEncryptedKeyPair) {
                if (password == null) {
                    throw new ImportException("Unable to import private key. Key is encrypted, but no password was provided.");
                }
                PEMDecryptorProvider decryptor = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
                PEMKeyPair decryptedKeyPair = ((PEMEncryptedKeyPair)keyPair).decryptKeyPair(decryptor);
                keyInfo = decryptedKeyPair.getPrivateKeyInfo();
            } else {
                keyInfo = ((PEMKeyPair)keyPair).getPrivateKeyInfo();
            }
            privateKey = new JcaPEMKeyConverter().getPrivateKey(keyInfo);
        }
        catch (Throwable throwable) {
            try {
                try {
                    pemParser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ImportException("Unable to read PEM-encoded PrivateKey", e);
            }
        }
        pemParser.close();
        return privateKey;
    }

    @Override
    public X509Certificate decodePemEncodedCertificate(Reader certificateReader) {
        throw new UnsupportedOperationException("BouncyCastle implementation does not implement this method");
    }

    @Override
    public KeyStore loadKeyStore(File file, String keyStoreType, String password) {
        throw new UnsupportedOperationException("BouncyCastle implementation does not implement this method");
    }

    @Override
    public void saveKeyStore(File file, KeyStore keyStore, String keystorePassword) {
        throw new UnsupportedOperationException("BouncyCastle implementation does not implement this method");
    }

    @Override
    public KeyManager[] getKeyManagers(KeyStore keyStore, String keyStorePassword) {
        return new KeyManager[0];
    }

    private static X500Name createX500NameForCertificate(CertificateInfo certificateInfo) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        if (certificateInfo.getCommonName() != null) {
            x500NameBuilder.addRDN(BCStyle.CN, certificateInfo.getCommonName());
        }
        if (certificateInfo.getOrganization() != null) {
            x500NameBuilder.addRDN(BCStyle.O, certificateInfo.getOrganization());
        }
        if (certificateInfo.getOrganizationalUnit() != null) {
            x500NameBuilder.addRDN(BCStyle.OU, certificateInfo.getOrganizationalUnit());
        }
        if (certificateInfo.getEmail() != null) {
            x500NameBuilder.addRDN(BCStyle.E, certificateInfo.getEmail());
        }
        if (certificateInfo.getLocality() != null) {
            x500NameBuilder.addRDN(BCStyle.L, certificateInfo.getLocality());
        }
        if (certificateInfo.getState() != null) {
            x500NameBuilder.addRDN(BCStyle.ST, certificateInfo.getState());
        }
        if (certificateInfo.getCountryCode() != null) {
            x500NameBuilder.addRDN(BCStyle.C, certificateInfo.getCountryCode());
        }
        return x500NameBuilder.build();
    }

    private static GeneralNames getDomainNameSANsAsASN1Encodable(List<String> subjectAlternativeNames) {
        ArrayList encodedSANs = new ArrayList(subjectAlternativeNames.size());
        subjectAlternativeNames.forEach(subjectAlternativeName -> {
            boolean isIpAddress = InetAddresses.isInetAddress((String)subjectAlternativeName);
            GeneralName generalName = new GeneralName(isIpAddress ? 7 : 2, subjectAlternativeName);
            encodedSANs.add(generalName);
        });
        return new GeneralNames(encodedSANs.toArray(new GeneralName[0]));
    }

    private static ContentSigner getCertificateSigner(PrivateKey certAuthorityPrivateKey, String signatureAlgorithm) {
        try {
            return new JcaContentSignerBuilder(signatureAlgorithm).build(certAuthorityPrivateKey);
        }
        catch (OperatorCreationException e) {
            throw new CertificateCreationException("Unable to create ContentSigner using signature algorithm: " + signatureAlgorithm, e);
        }
    }

    private static X509Certificate convertToJcaCertificate(X509CertificateHolder bouncyCastleCertificate) {
        try {
            return new JcaX509CertificateConverter().getCertificate(bouncyCastleCertificate);
        }
        catch (CertificateException e) {
            throw new CertificateCreationException("Unable to convert X590CertificateHolder to JCA X590Certificate", e);
        }
    }

    private static SubjectKeyIdentifier createSubjectKeyIdentifier(Key key) {
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)key.getEncoded());
        return new BcX509ExtensionUtils().createSubjectKeyIdentifier(publicKeyInfo);
    }

    private static String encodeObjectAsPemString(Object object, PEMEncryptor encryptor) {
        StringWriter stringWriter = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
            pemWriter.writeObject(object, encryptor);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new ExportException("Unable to generate PEM string representing object", e);
        }
        return stringWriter.toString();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

