/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.io;

import com.cedarsoft.io.LinkType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class LinkUtils {
    public static boolean isLink(@Nonnull File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        String canonicalPath = file.getCanonicalPath();
        String absolutePath = file.getAbsolutePath();
        return !absolutePath.equals(canonicalPath);
    }

    public static boolean createLink(@Nonnull File linkTarget, @Nonnull File linkFile, @Nonnull LinkType linkType) throws IOException {
        return LinkUtils.createLink(linkTarget, linkFile, linkType == LinkType.SYMBOLIC);
    }

    public static boolean createSymbolicLink(@Nonnull File linkTarget, @Nonnull File linkFile) throws IOException {
        return LinkUtils.createLink(linkTarget, linkFile, true);
    }

    public static boolean createHardLink(@Nonnull File linkTarget, @Nonnull File linkFile) throws IOException {
        return LinkUtils.createLink(linkTarget, linkFile, false);
    }

    public static boolean createLink(@Nonnull File linkTarget, @Nonnull File linkFile, boolean symbolic) throws IOException {
        if (linkFile.exists()) {
            if (!symbolic) {
                throw new IOException("link still exists " + linkFile.getAbsolutePath());
            }
            if (linkFile.getCanonicalFile().equals(linkTarget.getCanonicalFile())) {
                return false;
            }
            throw new IOException("A link still exists at <" + linkFile.getAbsolutePath() + "> but with different target: <" + linkTarget.getCanonicalPath() + "> exected <" + linkFile.getCanonicalPath() + ">");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("ln");
        if (symbolic) {
            args.add("-s");
        }
        args.add(linkTarget.getPath());
        args.add(linkFile.getAbsolutePath());
        ProcessBuilder builder = new ProcessBuilder(args);
        Process process = builder.start();
        try {
            int result = process.waitFor();
            if (result != 0) {
                throw new IOException("Creation of link failed: " + IOUtils.toString((InputStream)process.getErrorStream()));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSymbolicLink(@Nonnull File linkFile) throws IOException {
        if (!linkFile.exists()) {
            throw new FileNotFoundException("No such symlink: " + linkFile);
        }
        File canonicalFile = linkFile.getCanonicalFile();
        File temp = LinkUtils.createTempFile("symlink", ".tmp", canonicalFile.getParentFile());
        try {
            try {
                FileUtils.moveFile((File)canonicalFile, (File)temp);
            }
            catch (IOException e) {
                throw new IOException("Couldn't rename resource when attempting to delete " + linkFile);
            }
            if (!linkFile.delete()) {
                throw new IOException("Couldn't delete symlink: " + linkFile + " (was it a real file? is this not a UNIX system?)");
            }
        }
        finally {
            try {
                FileUtils.moveFile((File)temp, (File)canonicalFile);
            }
            catch (IOException e) {
                throw new IOException("Couldn't return resource " + temp + " to its original name: " + canonicalFile.getAbsolutePath() + "\n THE RESOURCE'S NAME ON DISK HAS " + "BEEN CHANGED BY THIS ERROR!\n");
            }
        }
    }

    @Nonnull
    public static File createTempFile(@Nonnull String prefix, @Nonnull String suffix, @Nullable File parentDir) {
        File result;
        Random rand = new Random();
        String parent = parentDir == null ? System.getProperty("java.io.tmpdir") : parentDir.getPath();
        DecimalFormat fmt = new DecimalFormat("#####");
        while ((result = new File(parent, prefix + fmt.format(Math.abs(rand.nextInt())) + suffix)).exists()) {
        }
        return result;
    }

    public boolean isSymbolicLink(@Nonnull File file) throws IOException {
        return !file.getAbsoluteFile().equals(file.getCanonicalFile());
    }
}

