/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.io;

import java.io.File;
import javax.annotation.Nonnull;

public class RelativePathFinder {
    private static final char BACKSLASH = '\\';
    private static final char SLASH = '/';

    public static String getRelativePath(@Nonnull String target, @Nonnull String base, @Nonnull String separator) {
        String prefix2;
        int endPrefix;
        String prefix1;
        String canonicalTarget;
        String canonicalBase = base;
        if (base.charAt(base.length() - 1) == '/' || base.charAt(base.length() - 1) == '\\') {
            canonicalBase = base.substring(0, base.length() - 1);
        }
        if ((canonicalTarget = target).charAt(canonicalTarget.length() - 1) == '/' || canonicalTarget.charAt(canonicalTarget.length() - 1) == '\\') {
            canonicalTarget = canonicalTarget.substring(0, canonicalTarget.length() - 1);
        }
        if (canonicalTarget.equals(canonicalBase)) {
            return ".";
        }
        if (canonicalBase.substring(0, 2).equals("\\\\") ? !(prefix1 = canonicalBase.substring(0, endPrefix = canonicalBase.indexOf(92, 2))).equals(prefix2 = canonicalTarget.substring(0, endPrefix)) : (canonicalBase.substring(1, 3).equals(":\\") ? !(prefix1 = canonicalBase.substring(0, endPrefix = 2)).equals(prefix2 = canonicalTarget.substring(0, endPrefix)) : canonicalBase.charAt(0) == '/' && canonicalTarget.charAt(0) != '/')) {
            return canonicalTarget;
        }
        int minLength = canonicalBase.length();
        if (canonicalTarget.length() < minLength) {
            minLength = canonicalTarget.length();
        }
        int firstDifference = minLength + 1;
        int lastSeparator = -1;
        for (int i = 0; i < minLength; ++i) {
            if (canonicalTarget.charAt(i) == canonicalBase.charAt(i)) {
                if (canonicalTarget.charAt(i) != '/' && canonicalTarget.charAt(i) != '\\') continue;
                lastSeparator = i;
                continue;
            }
            firstDifference = lastSeparator + 1;
            break;
        }
        StringBuilder relativePath = new StringBuilder(50);
        if (canonicalBase.length() > firstDifference) {
            relativePath.append("..");
            for (int i = firstDifference; i < canonicalBase.length(); ++i) {
                if (canonicalBase.charAt(i) != '/' && canonicalBase.charAt(i) != '\\') continue;
                relativePath.append(separator);
                relativePath.append("..");
            }
        }
        if (canonicalTarget.length() > firstDifference) {
            if (relativePath.length() > 0) {
                relativePath.append(separator);
            }
            relativePath.append(canonicalTarget.substring(firstDifference));
        }
        return relativePath.toString();
    }

    @Nonnull
    public static File getRelativePath(@Nonnull File target, @Nonnull File base, @Nonnull String pathSeparator) {
        return new File(RelativePathFinder.getRelativePath(target.getPath(), base.getPath(), pathSeparator));
    }

    public static File getRelativePath(@Nonnull File target, @Nonnull File base) {
        return RelativePathFinder.getRelativePath(target, base, File.separator);
    }

    @Nonnull
    public static String getRelativePath(@Nonnull String targetPath, @Nonnull String basePath) {
        return RelativePathFinder.getRelativePath(targetPath, basePath, File.separator);
    }
}

