/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.Creator;
import com.datadog.api.v1.client.model.MonitorOptions;
import com.datadog.api.v1.client.model.MonitorOverallStates;
import com.datadog.api.v1.client.model.MonitorState;
import com.datadog.api.v1.client.model.MonitorType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Object describing a monitor.")
@JsonPropertyOrder(value={"created", "creator", "deleted", "id", "message", "modified", "multi", "name", "options", "overall_state", "priority", "query", "restricted_roles", "state", "tags", "type"})
public class Monitor {
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private Creator creator;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    private JsonNullable<OffsetDateTime> deleted = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private Long id;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_MODIFIED = "modified";
    private OffsetDateTime modified;
    public static final String JSON_PROPERTY_MULTI = "multi";
    private Boolean multi;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private MonitorOptions options;
    public static final String JSON_PROPERTY_OVERALL_STATE = "overall_state";
    private MonitorOverallStates overallState;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private Long priority;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_RESTRICTED_ROLES = "restricted_roles";
    private List<String> restrictedRoles = null;
    public static final String JSON_PROPERTY_STATE = "state";
    private MonitorState state;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private MonitorType type;

    public Monitor() {
    }

    @JsonCreator
    public Monitor(@JsonProperty(required=true, value="query") String query, @JsonProperty(required=true, value="type") MonitorType type) {
        this.query = query;
        this.type = type;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp of the monitor creation.")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public Monitor creator(Creator creator) {
        this.creator = creator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the monitor is deleted. (Always `null`)")
    @JsonIgnore
    public OffsetDateTime getDeleted() {
        if (this.deleted == null) {
            this.deleted = JsonNullable.undefined();
        }
        return (OffsetDateTime)this.deleted.orElse(null);
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getDeleted_JsonNullable() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    private void setDeleted_JsonNullable(JsonNullable<OffsetDateTime> deleted) {
        this.deleted = deleted;
    }

    @Nullable
    @ApiModelProperty(value="ID of this monitor.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getId() {
        return this.id;
    }

    public Monitor message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A message to include with notifications for this monitor.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Nullable
    @ApiModelProperty(value="Last timestamp when the monitor was edited.")
    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModified() {
        return this.modified;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the monitor is broken down on different groups.")
    @JsonProperty(value="multi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMulti() {
        return this.multi;
    }

    public Monitor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The monitor name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Monitor options(MonitorOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorOptions getOptions() {
        return this.options;
    }

    public void setOptions(MonitorOptions options) {
        this.options = options;
    }

    public Monitor overallState(MonitorOverallStates overallState) {
        this.overallState = overallState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="overall_state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorOverallStates getOverallState() {
        return this.overallState;
    }

    public void setOverallState(MonitorOverallStates overallState) {
        this.overallState = overallState;
    }

    public Monitor priority(Long priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Integer from 1 (high) to 5 (low) indicating alert severity.")
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public Monitor query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="avg(last_5m):sum:system.net.bytes_rcvd{host:host0} > 100", required=true, value="The monitor query.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Monitor restrictedRoles(List<String> restrictedRoles) {
        this.restrictedRoles = restrictedRoles;
        return this;
    }

    public Monitor addRestrictedRolesItem(String restrictedRolesItem) {
        if (this.restrictedRoles == null) {
            this.restrictedRoles = new ArrayList<String>();
        }
        this.restrictedRoles.add(restrictedRolesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of role identifiers that can be pulled from the Roles API. Cannot be used with `locked` option.")
    @JsonProperty(value="restricted_roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRestrictedRoles() {
        return this.restrictedRoles;
    }

    public void setRestrictedRoles(List<String> restrictedRoles) {
        this.restrictedRoles = restrictedRoles;
    }

    public Monitor state(MonitorState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorState getState() {
        return this.state;
    }

    public void setState(MonitorState state) {
        this.state = state;
    }

    public Monitor tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Monitor addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tags associated to your monitor.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Monitor type(MonitorType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MonitorType getType() {
        return this.type;
    }

    public void setType(MonitorType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Monitor monitor = (Monitor)o;
        return Objects.equals(this.created, monitor.created) && Objects.equals(this.creator, monitor.creator) && Objects.equals(this.deleted, monitor.deleted) && Objects.equals(this.id, monitor.id) && Objects.equals(this.message, monitor.message) && Objects.equals(this.modified, monitor.modified) && Objects.equals(this.multi, monitor.multi) && Objects.equals(this.name, monitor.name) && Objects.equals(this.options, monitor.options) && Objects.equals((Object)this.overallState, (Object)monitor.overallState) && Objects.equals(this.priority, monitor.priority) && Objects.equals(this.query, monitor.query) && Objects.equals(this.restrictedRoles, monitor.restrictedRoles) && Objects.equals(this.state, monitor.state) && Objects.equals(this.tags, monitor.tags) && Objects.equals((Object)this.type, (Object)monitor.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.creator, this.deleted, this.id, this.message, this.modified, this.multi, this.name, this.options, this.overallState, this.priority, this.query, this.restrictedRoles, this.state, this.tags, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Monitor {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    multi: ").append(this.toIndentedString(this.multi)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    overallState: ").append(this.toIndentedString((Object)this.overallState)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    restrictedRoles: ").append(this.toIndentedString(this.restrictedRoles)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

