/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SLOBulkDeleteError;
import com.datadog.api.v1.client.model.SLOBulkDeleteResponseData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The bulk partial delete service level objective object endpoint response.  This endpoint operates on multiple service level objective objects, so it may be partially successful. In such cases, the \"data\" and \"error\" fields in this response indicate which deletions succeeded and failed.")
@JsonPropertyOrder(value={"data", "errors"})
public class SLOBulkDeleteResponse {
    public static final String JSON_PROPERTY_DATA = "data";
    private SLOBulkDeleteResponseData data;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<SLOBulkDeleteError> errors = null;

    public SLOBulkDeleteResponse data(SLOBulkDeleteResponseData data) {
        this.data = data;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOBulkDeleteResponseData getData() {
        return this.data;
    }

    public void setData(SLOBulkDeleteResponseData data) {
        this.data = data;
    }

    public SLOBulkDeleteResponse errors(List<SLOBulkDeleteError> errors) {
        this.errors = errors;
        return this;
    }

    public SLOBulkDeleteResponse addErrorsItem(SLOBulkDeleteError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<SLOBulkDeleteError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of errors object returned.")
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SLOBulkDeleteError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<SLOBulkDeleteError> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOBulkDeleteResponse slOBulkDeleteResponse = (SLOBulkDeleteResponse)o;
        return Objects.equals(this.data, slOBulkDeleteResponse.data) && Objects.equals(this.errors, slOBulkDeleteResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOBulkDeleteResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

