/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.UsageAttributionValues;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Usage Summary by tag for a given organization.")
@JsonPropertyOrder(value={"month", "org_name", "public_id", "tag_config_source", "tags", "updated_at", "values"})
public class UsageAttributionBody {
    public static final String JSON_PROPERTY_MONTH = "month";
    private OffsetDateTime month;
    public static final String JSON_PROPERTY_ORG_NAME = "org_name";
    private String orgName;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_TAG_CONFIG_SOURCE = "tag_config_source";
    private String tagConfigSource;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, List<String>> tags = null;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private String updatedAt;
    public static final String JSON_PROPERTY_VALUES = "values";
    private UsageAttributionValues values;

    public UsageAttributionBody month(OffsetDateTime month) {
        this.month = month;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Datetime in ISO-8601 format, UTC, precise to month: [YYYY-MM].")
    @JsonProperty(value="month")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getMonth() {
        return this.month;
    }

    public void setMonth(OffsetDateTime month) {
        this.month = month;
    }

    public UsageAttributionBody orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the organization.")
    @JsonProperty(value="org_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public UsageAttributionBody publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The organization public ID.")
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public UsageAttributionBody tagConfigSource(String tagConfigSource) {
        this.tagConfigSource = tagConfigSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source of the usage attribution tag configuration and the selected tags in the format `<source_org_name>:<selected tag 1>-<selected tag 2>-<selected tag 3>`.")
    @JsonProperty(value="tag_config_source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTagConfigSource() {
        return this.tagConfigSource;
    }

    public void setTagConfigSource(String tagConfigSource) {
        this.tagConfigSource = tagConfigSource;
    }

    public UsageAttributionBody tags(Map<String, List<String>> tags) {
        this.tags = tags;
        return this;
    }

    public UsageAttributionBody putTagsItem(String key, List<String> tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, List<String>>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Usage Summary by tag name.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, List<String>> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, List<String>> tags) {
        this.tags = tags;
    }

    public UsageAttributionBody updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the the most recent hour in the current months for all organizations for which all usages were calculated.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public UsageAttributionBody values(UsageAttributionValues values) {
        this.values = values;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageAttributionValues getValues() {
        return this.values;
    }

    public void setValues(UsageAttributionValues values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageAttributionBody usageAttributionBody = (UsageAttributionBody)o;
        return Objects.equals(this.month, usageAttributionBody.month) && Objects.equals(this.orgName, usageAttributionBody.orgName) && Objects.equals(this.publicId, usageAttributionBody.publicId) && Objects.equals(this.tagConfigSource, usageAttributionBody.tagConfigSource) && Objects.equals(this.tags, usageAttributionBody.tags) && Objects.equals(this.updatedAt, usageAttributionBody.updatedAt) && Objects.equals(this.values, usageAttributionBody.values);
    }

    public int hashCode() {
        return Objects.hash(this.month, this.orgName, this.publicId, this.tagConfigSource, this.tags, this.updatedAt, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageAttributionBody {\n");
        sb.append("    month: ").append(this.toIndentedString(this.month)).append("\n");
        sb.append("    orgName: ").append(this.toIndentedString(this.orgName)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    tagConfigSource: ").append(this.toIndentedString(this.tagConfigSource)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

