/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.IncidentResponseAttributes;
import com.datadog.api.v2.client.model.IncidentResponseRelationships;
import com.datadog.api.v2.client.model.IncidentType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Incident data from a response.")
@JsonPropertyOrder(value={"attributes", "id", "relationships", "type"})
public class IncidentResponseData {
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private IncidentResponseAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private IncidentResponseRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private IncidentType type = IncidentType.INCIDENTS;

    public IncidentResponseData() {
    }

    @JsonCreator
    public IncidentResponseData(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") IncidentType type) {
        this.id = id;
        this.type = type;
    }

    public IncidentResponseData attributes(IncidentResponseAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentResponseAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(IncidentResponseAttributes attributes) {
        this.attributes = attributes;
    }

    public IncidentResponseData id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", required=true, value="The incident's ID.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IncidentResponseData relationships(IncidentResponseRelationships relationships) {
        this.relationships = relationships;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentResponseRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(IncidentResponseRelationships relationships) {
        this.relationships = relationships;
    }

    public IncidentResponseData type(IncidentType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IncidentType getType() {
        return this.type;
    }

    public void setType(IncidentType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentResponseData incidentResponseData = (IncidentResponseData)o;
        return Objects.equals(this.attributes, incidentResponseData.attributes) && Objects.equals(this.id, incidentResponseData.id) && Objects.equals(this.relationships, incidentResponseData.relationships) && Objects.equals((Object)this.type, (Object)incidentResponseData.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this.id, this.relationships, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentResponseData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

