/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.EventCreateRequest;
import com.datadog.api.v1.client.model.EventCreateResponse;
import com.datadog.api.v1.client.model.EventListResponse;
import com.datadog.api.v1.client.model.EventPriority;
import com.datadog.api.v1.client.model.EventResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class EventsApi {
    private ApiClient apiClient;

    public EventsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EventsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public EventCreateResponse createEvent(EventCreateRequest body) throws ApiException {
        return this.createEventWithHttpInfo(body).getData();
    }

    public ApiResponse<EventCreateResponse> createEventWithHttpInfo(EventCreateRequest body) throws ApiException {
        EventCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createEvent");
        }
        String localVarPath = "/api/v1/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createEvent");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth"};
        GenericType<EventCreateResponse> localVarReturnType = new GenericType<EventCreateResponse>(){};
        return this.apiClient.invokeAPI("EventsApi.createEvent", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public EventResponse getEvent(Long eventId) throws ApiException {
        return this.getEventWithHttpInfo(eventId).getData();
    }

    public ApiResponse<EventResponse> getEventWithHttpInfo(Long eventId) throws ApiException {
        Object localVarPostBody = null;
        if (eventId == null) {
            throw new ApiException(400, "Missing the required parameter 'eventId' when calling getEvent");
        }
        String localVarPath = "/api/v1/events/{event_id}".replaceAll("\\{event_id\\}", this.apiClient.escapeString(eventId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getEvent");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<EventResponse> localVarReturnType = new GenericType<EventResponse>(){};
        return this.apiClient.invokeAPI("EventsApi.getEvent", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public EventListResponse listEvents(Long start, Long end) throws ApiException {
        return this.listEventsWithHttpInfo(start, end, new ListEventsOptionalParameters()).getData();
    }

    public EventListResponse listEvents(Long start, Long end, ListEventsOptionalParameters parameters) throws ApiException {
        return this.listEventsWithHttpInfo(start, end, parameters).getData();
    }

    public ApiResponse<EventListResponse> listEventsWithHttpInfo(Long start, Long end, ListEventsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (start == null) {
            throw new ApiException(400, "Missing the required parameter 'start' when calling listEvents");
        }
        if (end == null) {
            throw new ApiException(400, "Missing the required parameter 'end' when calling listEvents");
        }
        EventPriority priority = parameters.priority;
        String sources = parameters.sources;
        String tags = parameters.tags;
        Boolean unaggregated = parameters.unaggregated;
        Boolean excludeAggregate = parameters.excludeAggregate;
        Integer page = parameters.page;
        String localVarPath = "/api/v1/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end", end));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "priority", (Object)priority));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sources", sources));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "unaggregated", unaggregated));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "exclude_aggregate", excludeAggregate));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarHeaderParams.put("DD-OPERATION-ID", "listEvents");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<EventListResponse> localVarReturnType = new GenericType<EventListResponse>(){};
        return this.apiClient.invokeAPI("EventsApi.listEvents", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class ListEventsOptionalParameters {
        private EventPriority priority;
        private String sources;
        private String tags;
        private Boolean unaggregated;
        private Boolean excludeAggregate;
        private Integer page;

        public ListEventsOptionalParameters priority(EventPriority priority) {
            this.priority = priority;
            return this;
        }

        public ListEventsOptionalParameters sources(String sources) {
            this.sources = sources;
            return this;
        }

        public ListEventsOptionalParameters tags(String tags) {
            this.tags = tags;
            return this;
        }

        public ListEventsOptionalParameters unaggregated(Boolean unaggregated) {
            this.unaggregated = unaggregated;
            return this;
        }

        public ListEventsOptionalParameters excludeAggregate(Boolean excludeAggregate) {
            this.excludeAggregate = excludeAggregate;
            return this;
        }

        public ListEventsOptionalParameters page(Integer page) {
            this.page = page;
            return this;
        }
    }
}

