/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.CheckCanDeleteMonitorResponse;
import com.datadog.api.v1.client.model.DeletedMonitor;
import com.datadog.api.v1.client.model.Monitor;
import com.datadog.api.v1.client.model.MonitorGroupSearchResponse;
import com.datadog.api.v1.client.model.MonitorSearchResponse;
import com.datadog.api.v1.client.model.MonitorUpdateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class MonitorsApi {
    private ApiClient apiClient;

    public MonitorsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MonitorsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CheckCanDeleteMonitorResponse checkCanDeleteMonitor(List<Long> monitorIds) throws ApiException {
        return this.checkCanDeleteMonitorWithHttpInfo(monitorIds).getData();
    }

    public ApiResponse<CheckCanDeleteMonitorResponse> checkCanDeleteMonitorWithHttpInfo(List<Long> monitorIds) throws ApiException {
        Object localVarPostBody = null;
        if (monitorIds == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorIds' when calling checkCanDeleteMonitor");
        }
        String localVarPath = "/api/v1/monitor/can_delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "monitor_ids", monitorIds));
        localVarHeaderParams.put("DD-OPERATION-ID", "checkCanDeleteMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<CheckCanDeleteMonitorResponse> localVarReturnType = new GenericType<CheckCanDeleteMonitorResponse>(){};
        return this.apiClient.invokeAPI("MonitorsApi.checkCanDeleteMonitor", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Monitor createMonitor(Monitor body) throws ApiException {
        return this.createMonitorWithHttpInfo(body).getData();
    }

    public ApiResponse<Monitor> createMonitorWithHttpInfo(Monitor body) throws ApiException {
        Monitor localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createMonitor");
        }
        String localVarPath = "/api/v1/monitor";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Monitor> localVarReturnType = new GenericType<Monitor>(){};
        return this.apiClient.invokeAPI("MonitorsApi.createMonitor", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public DeletedMonitor deleteMonitor(Long monitorId) throws ApiException {
        return this.deleteMonitorWithHttpInfo(monitorId, new DeleteMonitorOptionalParameters()).getData();
    }

    public DeletedMonitor deleteMonitor(Long monitorId, DeleteMonitorOptionalParameters parameters) throws ApiException {
        return this.deleteMonitorWithHttpInfo(monitorId, parameters).getData();
    }

    public ApiResponse<DeletedMonitor> deleteMonitorWithHttpInfo(Long monitorId, DeleteMonitorOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling deleteMonitor");
        }
        String force = parameters.force;
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "force", force));
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<DeletedMonitor> localVarReturnType = new GenericType<DeletedMonitor>(){};
        return this.apiClient.invokeAPI("MonitorsApi.deleteMonitor", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Monitor getMonitor(Long monitorId) throws ApiException {
        return this.getMonitorWithHttpInfo(monitorId, new GetMonitorOptionalParameters()).getData();
    }

    public Monitor getMonitor(Long monitorId, GetMonitorOptionalParameters parameters) throws ApiException {
        return this.getMonitorWithHttpInfo(monitorId, parameters).getData();
    }

    public ApiResponse<Monitor> getMonitorWithHttpInfo(Long monitorId, GetMonitorOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling getMonitor");
        }
        String groupStates = parameters.groupStates;
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_states", groupStates));
        localVarHeaderParams.put("DD-OPERATION-ID", "getMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Monitor> localVarReturnType = new GenericType<Monitor>(){};
        return this.apiClient.invokeAPI("MonitorsApi.getMonitor", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public List<Monitor> listMonitors() throws ApiException {
        return this.listMonitorsWithHttpInfo(new ListMonitorsOptionalParameters()).getData();
    }

    public List<Monitor> listMonitors(ListMonitorsOptionalParameters parameters) throws ApiException {
        return this.listMonitorsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<List<Monitor>> listMonitorsWithHttpInfo(ListMonitorsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String groupStates = parameters.groupStates;
        String name = parameters.name;
        String tags = parameters.tags;
        String monitorTags = parameters.monitorTags;
        Boolean withDowntimes = parameters.withDowntimes;
        Long idOffset = parameters.idOffset;
        Long page = parameters.page;
        Integer pageSize = parameters.pageSize;
        String localVarPath = "/api/v1/monitor";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_states", groupStates));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "monitor_tags", monitorTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_downtimes", withDowntimes));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id_offset", idOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarHeaderParams.put("DD-OPERATION-ID", "listMonitors");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<List<Monitor>> localVarReturnType = new GenericType<List<Monitor>>(){};
        return this.apiClient.invokeAPI("MonitorsApi.listMonitors", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public MonitorGroupSearchResponse searchMonitorGroups() throws ApiException {
        return this.searchMonitorGroupsWithHttpInfo(new SearchMonitorGroupsOptionalParameters()).getData();
    }

    public MonitorGroupSearchResponse searchMonitorGroups(SearchMonitorGroupsOptionalParameters parameters) throws ApiException {
        return this.searchMonitorGroupsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<MonitorGroupSearchResponse> searchMonitorGroupsWithHttpInfo(SearchMonitorGroupsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String query = parameters.query;
        Long page = parameters.page;
        Long perPage = parameters.perPage;
        String sort = parameters.sort;
        String localVarPath = "/api/v1/monitor/groups/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarHeaderParams.put("DD-OPERATION-ID", "searchMonitorGroups");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<MonitorGroupSearchResponse> localVarReturnType = new GenericType<MonitorGroupSearchResponse>(){};
        return this.apiClient.invokeAPI("MonitorsApi.searchMonitorGroups", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public MonitorSearchResponse searchMonitors() throws ApiException {
        return this.searchMonitorsWithHttpInfo(new SearchMonitorsOptionalParameters()).getData();
    }

    public MonitorSearchResponse searchMonitors(SearchMonitorsOptionalParameters parameters) throws ApiException {
        return this.searchMonitorsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<MonitorSearchResponse> searchMonitorsWithHttpInfo(SearchMonitorsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String query = parameters.query;
        Long page = parameters.page;
        Long perPage = parameters.perPage;
        String sort = parameters.sort;
        String localVarPath = "/api/v1/monitor/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarHeaderParams.put("DD-OPERATION-ID", "searchMonitors");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<MonitorSearchResponse> localVarReturnType = new GenericType<MonitorSearchResponse>(){};
        return this.apiClient.invokeAPI("MonitorsApi.searchMonitors", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Monitor updateMonitor(Long monitorId, MonitorUpdateRequest body) throws ApiException {
        return this.updateMonitorWithHttpInfo(monitorId, body).getData();
    }

    public ApiResponse<Monitor> updateMonitorWithHttpInfo(Long monitorId, MonitorUpdateRequest body) throws ApiException {
        MonitorUpdateRequest localVarPostBody = body;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling updateMonitor");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateMonitor");
        }
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Monitor> localVarReturnType = new GenericType<Monitor>(){};
        return this.apiClient.invokeAPI("MonitorsApi.updateMonitor", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Object validateMonitor(Monitor body) throws ApiException {
        return this.validateMonitorWithHttpInfo(body).getData();
    }

    public ApiResponse<Object> validateMonitorWithHttpInfo(Monitor body) throws ApiException {
        Monitor localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling validateMonitor");
        }
        String localVarPath = "/api/v1/monitor/validate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "validateMonitor");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("MonitorsApi.validateMonitor", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class SearchMonitorsOptionalParameters {
        private String query;
        private Long page;
        private Long perPage;
        private String sort;

        public SearchMonitorsOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public SearchMonitorsOptionalParameters page(Long page) {
            this.page = page;
            return this;
        }

        public SearchMonitorsOptionalParameters perPage(Long perPage) {
            this.perPage = perPage;
            return this;
        }

        public SearchMonitorsOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }
    }

    public static class SearchMonitorGroupsOptionalParameters {
        private String query;
        private Long page;
        private Long perPage;
        private String sort;

        public SearchMonitorGroupsOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public SearchMonitorGroupsOptionalParameters page(Long page) {
            this.page = page;
            return this;
        }

        public SearchMonitorGroupsOptionalParameters perPage(Long perPage) {
            this.perPage = perPage;
            return this;
        }

        public SearchMonitorGroupsOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }
    }

    public static class ListMonitorsOptionalParameters {
        private String groupStates;
        private String name;
        private String tags;
        private String monitorTags;
        private Boolean withDowntimes;
        private Long idOffset;
        private Long page;
        private Integer pageSize;

        public ListMonitorsOptionalParameters groupStates(String groupStates) {
            this.groupStates = groupStates;
            return this;
        }

        public ListMonitorsOptionalParameters name(String name) {
            this.name = name;
            return this;
        }

        public ListMonitorsOptionalParameters tags(String tags) {
            this.tags = tags;
            return this;
        }

        public ListMonitorsOptionalParameters monitorTags(String monitorTags) {
            this.monitorTags = monitorTags;
            return this;
        }

        public ListMonitorsOptionalParameters withDowntimes(Boolean withDowntimes) {
            this.withDowntimes = withDowntimes;
            return this;
        }

        public ListMonitorsOptionalParameters idOffset(Long idOffset) {
            this.idOffset = idOffset;
            return this;
        }

        public ListMonitorsOptionalParameters page(Long page) {
            this.page = page;
            return this;
        }

        public ListMonitorsOptionalParameters pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetMonitorOptionalParameters {
        private String groupStates;

        public GetMonitorOptionalParameters groupStates(String groupStates) {
            this.groupStates = groupStates;
            return this;
        }
    }

    public static class DeleteMonitorOptionalParameters {
        private String force;

        public DeleteMonitorOptionalParameters force(String force) {
            this.force = force;
            return this;
        }
    }
}

