/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.IdpResponse;
import com.datadog.api.v1.client.model.Organization;
import com.datadog.api.v1.client.model.OrganizationCreateBody;
import com.datadog.api.v1.client.model.OrganizationCreateResponse;
import com.datadog.api.v1.client.model.OrganizationListResponse;
import com.datadog.api.v1.client.model.OrganizationResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class OrganizationsApi {
    private ApiClient apiClient;

    public OrganizationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrganizationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OrganizationCreateResponse createChildOrg(OrganizationCreateBody body) throws ApiException {
        return this.createChildOrgWithHttpInfo(body).getData();
    }

    public ApiResponse<OrganizationCreateResponse> createChildOrgWithHttpInfo(OrganizationCreateBody body) throws ApiException {
        OrganizationCreateBody localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createChildOrg");
        }
        String localVarPath = "/api/v1/org";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createChildOrg");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<OrganizationCreateResponse> localVarReturnType = new GenericType<OrganizationCreateResponse>(){};
        return this.apiClient.invokeAPI("OrganizationsApi.createChildOrg", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public OrganizationResponse getOrg(String publicId) throws ApiException {
        return this.getOrgWithHttpInfo(publicId).getData();
    }

    public ApiResponse<OrganizationResponse> getOrgWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getOrg");
        }
        String localVarPath = "/api/v1/org/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getOrg");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<OrganizationResponse> localVarReturnType = new GenericType<OrganizationResponse>(){};
        return this.apiClient.invokeAPI("OrganizationsApi.getOrg", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public OrganizationListResponse listOrgs() throws ApiException {
        return this.listOrgsWithHttpInfo().getData();
    }

    public ApiResponse<OrganizationListResponse> listOrgsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/org";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listOrgs");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<OrganizationListResponse> localVarReturnType = new GenericType<OrganizationListResponse>(){};
        return this.apiClient.invokeAPI("OrganizationsApi.listOrgs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public OrganizationResponse updateOrg(String publicId, Organization body) throws ApiException {
        return this.updateOrgWithHttpInfo(publicId, body).getData();
    }

    public ApiResponse<OrganizationResponse> updateOrgWithHttpInfo(String publicId, Organization body) throws ApiException {
        Organization localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateOrg");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOrg");
        }
        String localVarPath = "/api/v1/org/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateOrg");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<OrganizationResponse> localVarReturnType = new GenericType<OrganizationResponse>(){};
        return this.apiClient.invokeAPI("OrganizationsApi.updateOrg", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public IdpResponse uploadIdPForOrg(String publicId, File idpFile) throws ApiException {
        return this.uploadIdPForOrgWithHttpInfo(publicId, idpFile).getData();
    }

    public ApiResponse<IdpResponse> uploadIdPForOrgWithHttpInfo(String publicId, File idpFile) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling uploadIdPForOrg");
        }
        if (idpFile == null) {
            throw new ApiException(400, "Missing the required parameter 'idpFile' when calling uploadIdPForOrg");
        }
        String localVarPath = "/api/v1/org/{public_id}/idp_metadata".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "uploadIdPForOrg");
        if (idpFile != null) {
            localVarFormParams.put("idp_file", idpFile);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IdpResponse> localVarReturnType = new GenericType<IdpResponse>(){};
        return this.apiClient.invokeAPI("OrganizationsApi.uploadIdPForOrg", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

