/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object representing a graph snapshot.")
@JsonPropertyOrder(value={"graph_def", "metric_query", "snapshot_url"})
public class GraphSnapshot {
    public static final String JSON_PROPERTY_GRAPH_DEF = "graph_def";
    private String graphDef;
    public static final String JSON_PROPERTY_METRIC_QUERY = "metric_query";
    private String metricQuery;
    public static final String JSON_PROPERTY_SNAPSHOT_URL = "snapshot_url";
    private String snapshotUrl;

    public GraphSnapshot graphDef(String graphDef) {
        this.graphDef = graphDef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON document defining the graph. `graph_def` can be used instead of `metric_query`. The JSON document uses the [grammar defined here](https://docs.datadoghq.com/graphing/graphing_json/#grammar) and should be formatted to a single line then URL encoded.")
    @JsonProperty(value="graph_def")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGraphDef() {
        return this.graphDef;
    }

    public void setGraphDef(String graphDef) {
        this.graphDef = graphDef;
    }

    public GraphSnapshot metricQuery(String metricQuery) {
        this.metricQuery = metricQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The metric query. One of `metric_query` or `graph_def` is required.")
    @JsonProperty(value="metric_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetricQuery() {
        return this.metricQuery;
    }

    public void setMetricQuery(String metricQuery) {
        this.metricQuery = metricQuery;
    }

    public GraphSnapshot snapshotUrl(String snapshotUrl) {
        this.snapshotUrl = snapshotUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://app.datadoghq.com/s/f12345678/aaa-bbb-ccc", value="URL of your [graph snapshot](https://docs.datadoghq.com/metrics/explorer/#snapshot).")
    @JsonProperty(value="snapshot_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSnapshotUrl() {
        return this.snapshotUrl;
    }

    public void setSnapshotUrl(String snapshotUrl) {
        this.snapshotUrl = snapshotUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphSnapshot graphSnapshot = (GraphSnapshot)o;
        return Objects.equals(this.graphDef, graphSnapshot.graphDef) && Objects.equals(this.metricQuery, graphSnapshot.metricQuery) && Objects.equals(this.snapshotUrl, graphSnapshot.snapshotUrl);
    }

    public int hashCode() {
        return Objects.hash(this.graphDef, this.metricQuery, this.snapshotUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GraphSnapshot {\n");
        sb.append("    graphDef: ").append(this.toIndentedString(this.graphDef)).append("\n");
        sb.append("    metricQuery: ").append(this.toIndentedString(this.metricQuery)).append("\n");
        sb.append("    snapshotUrl: ").append(this.toIndentedString(this.snapshotUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

