/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsServiceRemapperType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Use this processor if you want to assign one or more attributes as the official service.  **Note:** If multiple service remapper processors can be applied to a given log, only the first one (according to the pipeline order) is taken into account.")
@JsonPropertyOrder(value={"is_enabled", "name", "sources", "type"})
public class LogsServiceRemapper {
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = new ArrayList<String>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsServiceRemapperType type = LogsServiceRemapperType.SERVICE_REMAPPER;

    public LogsServiceRemapper() {
    }

    @JsonCreator
    public LogsServiceRemapper(@JsonProperty(required=true, value="sources") List<String> sources, @JsonProperty(required=true, value="type") LogsServiceRemapperType type) {
        this.sources = sources;
        this.type = type;
    }

    public LogsServiceRemapper isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the processor is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsServiceRemapper name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the processor.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsServiceRemapper sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public LogsServiceRemapper addSourcesItem(String sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @ApiModelProperty(example="[\"web\",\"gateway\"]", required=true, value="Array of source attributes.")
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public LogsServiceRemapper type(LogsServiceRemapperType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsServiceRemapperType getType() {
        return this.type;
    }

    public void setType(LogsServiceRemapperType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsServiceRemapper logsServiceRemapper = (LogsServiceRemapper)o;
        return Objects.equals(this.isEnabled, logsServiceRemapper.isEnabled) && Objects.equals(this.name, logsServiceRemapper.name) && Objects.equals(this.sources, logsServiceRemapper.sources) && Objects.equals((Object)this.type, (Object)logsServiceRemapper.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isEnabled, this.name, this.sources, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsServiceRemapper {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

