/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.OrganizationBilling;
import com.datadog.api.v1.client.model.OrganizationSettings;
import com.datadog.api.v1.client.model.OrganizationSubscription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Create, edit, and manage organizations.")
@JsonPropertyOrder(value={"billing", "created", "description", "name", "public_id", "settings", "subscription"})
public class Organization {
    public static final String JSON_PROPERTY_BILLING = "billing";
    private OrganizationBilling billing;
    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private OrganizationSettings settings;
    public static final String JSON_PROPERTY_SUBSCRIPTION = "subscription";
    private OrganizationSubscription subscription;

    public Organization billing(OrganizationBilling billing) {
        this.billing = billing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="billing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OrganizationBilling getBilling() {
        return this.billing;
    }

    public void setBilling(OrganizationBilling billing) {
        this.billing = billing;
    }

    @Nullable
    @ApiModelProperty(example="2019-09-26T17:28:28Z", value="Date of the organization creation.")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreated() {
        return this.created;
    }

    public Organization description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="some description", value="Description of the organization.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Organization name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="New child org", value="The name of the new child-organization, limited to 32 characters.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Organization publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="abcdef12345", value="The `public_id` of the organization you are operating within.")
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public Organization settings(OrganizationSettings settings) {
        this.settings = settings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OrganizationSettings getSettings() {
        return this.settings;
    }

    public void setSettings(OrganizationSettings settings) {
        this.settings = settings;
    }

    public Organization subscription(OrganizationSubscription subscription) {
        this.subscription = subscription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="subscription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OrganizationSubscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(OrganizationSubscription subscription) {
        this.subscription = subscription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization organization = (Organization)o;
        return Objects.equals(this.billing, organization.billing) && Objects.equals(this.created, organization.created) && Objects.equals(this.description, organization.description) && Objects.equals(this.name, organization.name) && Objects.equals(this.publicId, organization.publicId) && Objects.equals(this.settings, organization.settings) && Objects.equals(this.subscription, organization.subscription);
    }

    public int hashCode() {
        return Objects.hash(this.billing, this.created, this.description, this.name, this.publicId, this.settings, this.subscription);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Organization {\n");
        sb.append("    billing: ").append(this.toIndentedString(this.billing)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    subscription: ").append(this.toIndentedString(this.subscription)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

