/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.UserUpdateAttributes;
import com.datadog.api.v2.client.model.UsersType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Object to update a user.")
@JsonPropertyOrder(value={"attributes", "id", "type"})
public class UserUpdateData {
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private UserUpdateAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private UsersType type = UsersType.USERS;

    public UserUpdateData() {
    }

    @JsonCreator
    public UserUpdateData(@JsonProperty(required=true, value="attributes") UserUpdateAttributes attributes, @JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") UsersType type) {
        this.attributes = attributes;
        this.id = id;
        this.type = type;
    }

    public UserUpdateData attributes(UserUpdateAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserUpdateAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(UserUpdateAttributes attributes) {
        this.attributes = attributes;
    }

    public UserUpdateData id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", required=true, value="ID of the user.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UserUpdateData type(UsersType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UsersType getType() {
        return this.type;
    }

    public void setType(UsersType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserUpdateData userUpdateData = (UserUpdateData)o;
        return Objects.equals(this.attributes, userUpdateData.attributes) && Objects.equals(this.id, userUpdateData.id) && Objects.equals((Object)this.type, (Object)userUpdateData.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this.id, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserUpdateData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

