/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogStreamWidgetDefinition;
import com.datadog.api.v1.client.model.NotebookCellTime;
import com.datadog.api.v1.client.model.NotebookGraphSize;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"definition", "graph_size", "time"})
public class NotebookLogStreamCellAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DEFINITION = "definition";
    private LogStreamWidgetDefinition definition;
    public static final String JSON_PROPERTY_GRAPH_SIZE = "graph_size";
    private NotebookGraphSize graphSize;
    public static final String JSON_PROPERTY_TIME = "time";
    private JsonNullable<NotebookCellTime> time = JsonNullable.undefined();

    public NotebookLogStreamCellAttributes() {
    }

    @JsonCreator
    public NotebookLogStreamCellAttributes(@JsonProperty(required=true, value="definition") LogStreamWidgetDefinition definition) {
        this.definition = definition;
        this.unparsed |= definition.unparsed;
    }

    public NotebookLogStreamCellAttributes definition(LogStreamWidgetDefinition definition) {
        this.definition = definition;
        this.unparsed |= definition.unparsed;
        return this;
    }

    @JsonProperty(value="definition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogStreamWidgetDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(LogStreamWidgetDefinition definition) {
        this.definition = definition;
    }

    public NotebookLogStreamCellAttributes graphSize(NotebookGraphSize graphSize) {
        this.graphSize = graphSize;
        this.unparsed |= !graphSize.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="graph_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookGraphSize getGraphSize() {
        return this.graphSize;
    }

    public void setGraphSize(NotebookGraphSize graphSize) {
        if (!graphSize.isValid()) {
            this.unparsed = true;
        }
        this.graphSize = graphSize;
    }

    public NotebookLogStreamCellAttributes time(NotebookCellTime time) {
        this.time = JsonNullable.of((Object)time);
        return this;
    }

    @Nullable
    @JsonIgnore
    public NotebookCellTime getTime() {
        return (NotebookCellTime)this.time.orElse(null);
    }

    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<NotebookCellTime> getTime_JsonNullable() {
        return this.time;
    }

    @JsonProperty(value="time")
    public void setTime_JsonNullable(JsonNullable<NotebookCellTime> time) {
        this.time = time;
    }

    public void setTime(NotebookCellTime time) {
        this.time = JsonNullable.of((Object)time);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebookLogStreamCellAttributes notebookLogStreamCellAttributes = (NotebookLogStreamCellAttributes)o;
        return Objects.equals(this.definition, notebookLogStreamCellAttributes.definition) && Objects.equals(this.graphSize, notebookLogStreamCellAttributes.graphSize) && Objects.equals(this.time, notebookLogStreamCellAttributes.time);
    }

    public int hashCode() {
        return Objects.hash(this.definition, this.graphSize, this.time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotebookLogStreamCellAttributes {\n");
        sb.append("    definition: ").append(this.toIndentedString(this.definition)).append("\n");
        sb.append("    graphSize: ").append(this.toIndentedString(this.graphSize)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

