/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=WidgetTimeWindowsSerializer.class)
public class WidgetTimeWindows {
    public static final WidgetTimeWindows SEVEN_DAYS = new WidgetTimeWindows("7d");
    public static final WidgetTimeWindows THIRTY_DAYS = new WidgetTimeWindows("30d");
    public static final WidgetTimeWindows NINETY_DAYS = new WidgetTimeWindows("90d");
    public static final WidgetTimeWindows WEEK_TO_DATE = new WidgetTimeWindows("week_to_date");
    public static final WidgetTimeWindows PREVIOUS_WEEK = new WidgetTimeWindows("previous_week");
    public static final WidgetTimeWindows MONTH_TO_DATE = new WidgetTimeWindows("month_to_date");
    public static final WidgetTimeWindows PREVIOUS_MONTH = new WidgetTimeWindows("previous_month");
    public static final WidgetTimeWindows GLOBAL_TIME = new WidgetTimeWindows("global_time");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("7d", "30d", "90d", "week_to_date", "previous_week", "month_to_date", "previous_month", "global_time"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    WidgetTimeWindows(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((WidgetTimeWindows)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static WidgetTimeWindows fromValue(String value) {
        return new WidgetTimeWindows(value);
    }

    public static class WidgetTimeWindowsSerializer
    extends StdSerializer<WidgetTimeWindows> {
        public WidgetTimeWindowsSerializer(Class<WidgetTimeWindows> t) {
            super(t);
        }

        public WidgetTimeWindowsSerializer() {
            this(null);
        }

        public void serialize(WidgetTimeWindows value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

