/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.IncidentResponseData;
import com.datadog.api.v2.client.model.IncidentResponseIncludedItem;
import com.datadog.api.v2.client.model.IncidentResponseMeta;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"data", "included", "meta"})
public class IncidentsResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<IncidentResponseData> data = new ArrayList<IncidentResponseData>();
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<IncidentResponseIncludedItem> included = null;
    public static final String JSON_PROPERTY_META = "meta";
    private IncidentResponseMeta meta;

    public IncidentsResponse() {
    }

    @JsonCreator
    public IncidentsResponse(@JsonProperty(required=true, value="data") List<IncidentResponseData> data) {
        this.data = data;
    }

    public IncidentsResponse data(List<IncidentResponseData> data) {
        this.data = data;
        for (IncidentResponseData item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public IncidentsResponse addDataItem(IncidentResponseData dataItem) {
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IncidentResponseData> getData() {
        return this.data;
    }

    public void setData(List<IncidentResponseData> data) {
        this.data = data;
    }

    @Nullable
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IncidentResponseIncludedItem> getIncluded() {
        return this.included;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentResponseMeta getMeta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentsResponse incidentsResponse = (IncidentsResponse)o;
        return Objects.equals(this.data, incidentsResponse.data) && Objects.equals(this.included, incidentsResponse.included) && Objects.equals(this.meta, incidentsResponse.meta);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentsResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

