/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.RUMEvent;
import com.datadog.api.v2.client.model.RUMResponseLinks;
import com.datadog.api.v2.client.model.RUMResponseMetadata;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"data", "links", "meta"})
public class RUMEventsResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<RUMEvent> data = null;
    public static final String JSON_PROPERTY_LINKS = "links";
    private RUMResponseLinks links;
    public static final String JSON_PROPERTY_META = "meta";
    private RUMResponseMetadata meta;

    public RUMEventsResponse data(List<RUMEvent> data) {
        this.data = data;
        for (RUMEvent item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public RUMEventsResponse addDataItem(RUMEvent dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<RUMEvent>();
        }
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RUMEvent> getData() {
        return this.data;
    }

    public void setData(List<RUMEvent> data) {
        this.data = data;
    }

    public RUMEventsResponse links(RUMResponseLinks links) {
        this.links = links;
        this.unparsed |= links.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMResponseLinks getLinks() {
        return this.links;
    }

    public void setLinks(RUMResponseLinks links) {
        this.links = links;
    }

    public RUMEventsResponse meta(RUMResponseMetadata meta) {
        this.meta = meta;
        this.unparsed |= meta.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMResponseMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(RUMResponseMetadata meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RUMEventsResponse rumEventsResponse = (RUMEventsResponse)o;
        return Objects.equals(this.data, rumEventsResponse.data) && Objects.equals(this.links, rumEventsResponse.links) && Objects.equals(this.meta, rumEventsResponse.meta);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.links, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RUMEventsResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

