/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.SecurityFilterType;
import com.datadog.api.v2.client.model.SecurityFilterUpdateAttributes;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "type"})
public class SecurityFilterUpdateData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private SecurityFilterUpdateAttributes attributes;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SecurityFilterType type = SecurityFilterType.SECURITY_FILTERS;

    public SecurityFilterUpdateData() {
    }

    @JsonCreator
    public SecurityFilterUpdateData(@JsonProperty(required=true, value="attributes") SecurityFilterUpdateAttributes attributes, @JsonProperty(required=true, value="type") SecurityFilterType type) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public SecurityFilterUpdateData attributes(SecurityFilterUpdateAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityFilterUpdateAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(SecurityFilterUpdateAttributes attributes) {
        this.attributes = attributes;
    }

    public SecurityFilterUpdateData type(SecurityFilterType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityFilterType getType() {
        return this.type;
    }

    public void setType(SecurityFilterType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityFilterUpdateData securityFilterUpdateData = (SecurityFilterUpdateData)o;
        return Objects.equals(this.attributes, securityFilterUpdateData.attributes) && Objects.equals(this.type, securityFilterUpdateData.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityFilterUpdateData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

