/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=ScatterplotWidgetAggregatorSerializer.class)
public class ScatterplotWidgetAggregator {
    public static final ScatterplotWidgetAggregator AVERAGE = new ScatterplotWidgetAggregator("avg");
    public static final ScatterplotWidgetAggregator LAST = new ScatterplotWidgetAggregator("last");
    public static final ScatterplotWidgetAggregator MAXIMUM = new ScatterplotWidgetAggregator("max");
    public static final ScatterplotWidgetAggregator MINIMUM = new ScatterplotWidgetAggregator("min");
    public static final ScatterplotWidgetAggregator SUM = new ScatterplotWidgetAggregator("sum");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("avg", "last", "max", "min", "sum"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    ScatterplotWidgetAggregator(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((ScatterplotWidgetAggregator)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static ScatterplotWidgetAggregator fromValue(String value) {
        return new ScatterplotWidgetAggregator(value);
    }

    public static class ScatterplotWidgetAggregatorSerializer
    extends StdSerializer<ScatterplotWidgetAggregator> {
        public ScatterplotWidgetAggregatorSerializer(Class<ScatterplotWidgetAggregator> t) {
            super(t);
        }

        public ScatterplotWidgetAggregatorSerializer() {
            this(null);
        }

        public void serialize(ScatterplotWidgetAggregator value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

