/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.IntakePayloadAccepted;
import com.datadog.api.v2.client.model.MetricAllTagsResponse;
import com.datadog.api.v2.client.model.MetricBulkTagConfigCreateRequest;
import com.datadog.api.v2.client.model.MetricBulkTagConfigDeleteRequest;
import com.datadog.api.v2.client.model.MetricBulkTagConfigResponse;
import com.datadog.api.v2.client.model.MetricContentEncoding;
import com.datadog.api.v2.client.model.MetricEstimateResponse;
import com.datadog.api.v2.client.model.MetricPayload;
import com.datadog.api.v2.client.model.MetricTagConfigurationCreateRequest;
import com.datadog.api.v2.client.model.MetricTagConfigurationMetricTypes;
import com.datadog.api.v2.client.model.MetricTagConfigurationResponse;
import com.datadog.api.v2.client.model.MetricTagConfigurationUpdateRequest;
import com.datadog.api.v2.client.model.MetricVolumesResponse;
import com.datadog.api.v2.client.model.MetricsAndMetricTagConfigurationsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class MetricsApi {
    private ApiClient apiClient;

    public MetricsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MetricBulkTagConfigResponse createBulkTagsMetricsConfiguration(MetricBulkTagConfigCreateRequest body) throws ApiException {
        return this.createBulkTagsMetricsConfigurationWithHttpInfo(body).getData();
    }

    public CompletableFuture<MetricBulkTagConfigResponse> createBulkTagsMetricsConfigurationAsync(MetricBulkTagConfigCreateRequest body) {
        return this.createBulkTagsMetricsConfigurationWithHttpInfoAsync(body).thenApply(response -> (MetricBulkTagConfigResponse)response.getData());
    }

    public ApiResponse<MetricBulkTagConfigResponse> createBulkTagsMetricsConfigurationWithHttpInfo(MetricBulkTagConfigCreateRequest body) throws ApiException {
        MetricBulkTagConfigCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createBulkTagsMetricsConfiguration");
        }
        String localVarPath = "/api/v2/metrics/config/bulk-tags";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("MetricsApi.createBulkTagsMetricsConfiguration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricBulkTagConfigResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricBulkTagConfigResponse>> createBulkTagsMetricsConfigurationWithHttpInfoAsync(MetricBulkTagConfigCreateRequest body) {
        Invocation.Builder builder;
        MetricBulkTagConfigCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<MetricBulkTagConfigResponse>> result = new CompletableFuture<ApiResponse<MetricBulkTagConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createBulkTagsMetricsConfiguration"));
            return result;
        }
        String localVarPath = "/api/v2/metrics/config/bulk-tags";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("MetricsApi.createBulkTagsMetricsConfiguration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricBulkTagConfigResponse>> result = new CompletableFuture<ApiResponse<MetricBulkTagConfigResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricBulkTagConfigResponse>(){});
    }

    public MetricTagConfigurationResponse createTagConfiguration(String metricName, MetricTagConfigurationCreateRequest body) throws ApiException {
        return this.createTagConfigurationWithHttpInfo(metricName, body).getData();
    }

    public CompletableFuture<MetricTagConfigurationResponse> createTagConfigurationAsync(String metricName, MetricTagConfigurationCreateRequest body) {
        return this.createTagConfigurationWithHttpInfoAsync(metricName, body).thenApply(response -> (MetricTagConfigurationResponse)response.getData());
    }

    public ApiResponse<MetricTagConfigurationResponse> createTagConfigurationWithHttpInfo(String metricName, MetricTagConfigurationCreateRequest body) throws ApiException {
        MetricTagConfigurationCreateRequest localVarPostBody = body;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling createTagConfiguration");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTagConfiguration");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("MetricsApi.createTagConfiguration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricTagConfigurationResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricTagConfigurationResponse>> createTagConfigurationWithHttpInfoAsync(String metricName, MetricTagConfigurationCreateRequest body) {
        Invocation.Builder builder;
        MetricTagConfigurationCreateRequest localVarPostBody = body;
        if (metricName == null) {
            CompletableFuture<ApiResponse<MetricTagConfigurationResponse>> result = new CompletableFuture<ApiResponse<MetricTagConfigurationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricName' when calling createTagConfiguration"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<MetricTagConfigurationResponse>> result = new CompletableFuture<ApiResponse<MetricTagConfigurationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createTagConfiguration"));
            return result;
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("MetricsApi.createTagConfiguration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricTagConfigurationResponse>> result = new CompletableFuture<ApiResponse<MetricTagConfigurationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricTagConfigurationResponse>(){});
    }

    public MetricBulkTagConfigResponse deleteBulkTagsMetricsConfiguration(MetricBulkTagConfigDeleteRequest body) throws ApiException {
        return this.deleteBulkTagsMetricsConfigurationWithHttpInfo(body).getData();
    }

    public CompletableFuture<MetricBulkTagConfigResponse> deleteBulkTagsMetricsConfigurationAsync(MetricBulkTagConfigDeleteRequest body) {
        return this.deleteBulkTagsMetricsConfigurationWithHttpInfoAsync(body).thenApply(response -> (MetricBulkTagConfigResponse)response.getData());
    }

    public ApiResponse<MetricBulkTagConfigResponse> deleteBulkTagsMetricsConfigurationWithHttpInfo(MetricBulkTagConfigDeleteRequest body) throws ApiException {
        MetricBulkTagConfigDeleteRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteBulkTagsMetricsConfiguration");
        }
        String localVarPath = "/api/v2/metrics/config/bulk-tags";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("MetricsApi.deleteBulkTagsMetricsConfiguration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricBulkTagConfigResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricBulkTagConfigResponse>> deleteBulkTagsMetricsConfigurationWithHttpInfoAsync(MetricBulkTagConfigDeleteRequest body) {
        Invocation.Builder builder;
        MetricBulkTagConfigDeleteRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<MetricBulkTagConfigResponse>> result = new CompletableFuture<ApiResponse<MetricBulkTagConfigResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteBulkTagsMetricsConfiguration"));
            return result;
        }
        String localVarPath = "/api/v2/metrics/config/bulk-tags";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("MetricsApi.deleteBulkTagsMetricsConfiguration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricBulkTagConfigResponse>> result = new CompletableFuture<ApiResponse<MetricBulkTagConfigResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricBulkTagConfigResponse>(){});
    }

    public void deleteTagConfiguration(String metricName) throws ApiException {
        this.deleteTagConfigurationWithHttpInfo(metricName);
    }

    public CompletableFuture<Void> deleteTagConfigurationAsync(String metricName) {
        return this.deleteTagConfigurationWithHttpInfoAsync(metricName).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteTagConfigurationWithHttpInfo(String metricName) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling deleteTagConfiguration");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("MetricsApi.deleteTagConfiguration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteTagConfigurationWithHttpInfoAsync(String metricName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricName == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricName' when calling deleteTagConfiguration"));
            return result;
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("MetricsApi.deleteTagConfiguration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public MetricEstimateResponse estimateMetricsOutputSeries(String metricName) throws ApiException {
        return this.estimateMetricsOutputSeriesWithHttpInfo(metricName, new EstimateMetricsOutputSeriesOptionalParameters()).getData();
    }

    public CompletableFuture<MetricEstimateResponse> estimateMetricsOutputSeriesAsync(String metricName) {
        return this.estimateMetricsOutputSeriesWithHttpInfoAsync(metricName, new EstimateMetricsOutputSeriesOptionalParameters()).thenApply(response -> (MetricEstimateResponse)response.getData());
    }

    public MetricEstimateResponse estimateMetricsOutputSeries(String metricName, EstimateMetricsOutputSeriesOptionalParameters parameters) throws ApiException {
        return this.estimateMetricsOutputSeriesWithHttpInfo(metricName, parameters).getData();
    }

    public CompletableFuture<MetricEstimateResponse> estimateMetricsOutputSeriesAsync(String metricName, EstimateMetricsOutputSeriesOptionalParameters parameters) {
        return this.estimateMetricsOutputSeriesWithHttpInfoAsync(metricName, parameters).thenApply(response -> (MetricEstimateResponse)response.getData());
    }

    public ApiResponse<MetricEstimateResponse> estimateMetricsOutputSeriesWithHttpInfo(String metricName, EstimateMetricsOutputSeriesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling estimateMetricsOutputSeries");
        }
        String filterGroups = parameters.filterGroups;
        Integer filterHoursAgo = parameters.filterHoursAgo;
        Integer filterNumAggregations = parameters.filterNumAggregations;
        Boolean filterPct = parameters.filterPct;
        Integer filterTimespanH = parameters.filterTimespanH;
        String localVarPath = "/api/v2/metrics/{metric_name}/estimate".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[groups]", filterGroups));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[hours_ago]", filterHoursAgo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[num_aggregations]", filterNumAggregations));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[pct]", filterPct));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[timespan_h]", filterTimespanH));
        Invocation.Builder builder = this.apiClient.createBuilder("MetricsApi.estimateMetricsOutputSeries", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricEstimateResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricEstimateResponse>> estimateMetricsOutputSeriesWithHttpInfoAsync(String metricName, EstimateMetricsOutputSeriesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricName == null) {
            CompletableFuture<ApiResponse<MetricEstimateResponse>> result = new CompletableFuture<ApiResponse<MetricEstimateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricName' when calling estimateMetricsOutputSeries"));
            return result;
        }
        String filterGroups = parameters.filterGroups;
        Integer filterHoursAgo = parameters.filterHoursAgo;
        Integer filterNumAggregations = parameters.filterNumAggregations;
        Boolean filterPct = parameters.filterPct;
        Integer filterTimespanH = parameters.filterTimespanH;
        String localVarPath = "/api/v2/metrics/{metric_name}/estimate".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[groups]", filterGroups));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[hours_ago]", filterHoursAgo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[num_aggregations]", filterNumAggregations));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[pct]", filterPct));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[timespan_h]", filterTimespanH));
        try {
            builder = this.apiClient.createBuilder("MetricsApi.estimateMetricsOutputSeries", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricEstimateResponse>> result = new CompletableFuture<ApiResponse<MetricEstimateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricEstimateResponse>(){});
    }

    public MetricTagConfigurationResponse listTagConfigurationByName(String metricName) throws ApiException {
        return this.listTagConfigurationByNameWithHttpInfo(metricName).getData();
    }

    public CompletableFuture<MetricTagConfigurationResponse> listTagConfigurationByNameAsync(String metricName) {
        return this.listTagConfigurationByNameWithHttpInfoAsync(metricName).thenApply(response -> (MetricTagConfigurationResponse)response.getData());
    }

    public ApiResponse<MetricTagConfigurationResponse> listTagConfigurationByNameWithHttpInfo(String metricName) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling listTagConfigurationByName");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("MetricsApi.listTagConfigurationByName", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricTagConfigurationResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricTagConfigurationResponse>> listTagConfigurationByNameWithHttpInfoAsync(String metricName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricName == null) {
            CompletableFuture<ApiResponse<MetricTagConfigurationResponse>> result = new CompletableFuture<ApiResponse<MetricTagConfigurationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricName' when calling listTagConfigurationByName"));
            return result;
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("MetricsApi.listTagConfigurationByName", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricTagConfigurationResponse>> result = new CompletableFuture<ApiResponse<MetricTagConfigurationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricTagConfigurationResponse>(){});
    }

    public MetricsAndMetricTagConfigurationsResponse listTagConfigurations() throws ApiException {
        return this.listTagConfigurationsWithHttpInfo(new ListTagConfigurationsOptionalParameters()).getData();
    }

    public CompletableFuture<MetricsAndMetricTagConfigurationsResponse> listTagConfigurationsAsync() {
        return this.listTagConfigurationsWithHttpInfoAsync(new ListTagConfigurationsOptionalParameters()).thenApply(response -> (MetricsAndMetricTagConfigurationsResponse)response.getData());
    }

    public MetricsAndMetricTagConfigurationsResponse listTagConfigurations(ListTagConfigurationsOptionalParameters parameters) throws ApiException {
        return this.listTagConfigurationsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<MetricsAndMetricTagConfigurationsResponse> listTagConfigurationsAsync(ListTagConfigurationsOptionalParameters parameters) {
        return this.listTagConfigurationsWithHttpInfoAsync(parameters).thenApply(response -> (MetricsAndMetricTagConfigurationsResponse)response.getData());
    }

    public ApiResponse<MetricsAndMetricTagConfigurationsResponse> listTagConfigurationsWithHttpInfo(ListTagConfigurationsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Boolean filterConfigured = parameters.filterConfigured;
        String filterTagsConfigured = parameters.filterTagsConfigured;
        MetricTagConfigurationMetricTypes filterMetricType = parameters.filterMetricType;
        Boolean filterIncludePercentiles = parameters.filterIncludePercentiles;
        String filterTags = parameters.filterTags;
        Long windowSeconds = parameters.windowSeconds;
        String localVarPath = "/api/v2/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[configured]", filterConfigured));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags_configured]", filterTagsConfigured));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[metric_type]", filterMetricType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[include_percentiles]", filterIncludePercentiles));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "window[seconds]", windowSeconds));
        Invocation.Builder builder = this.apiClient.createBuilder("MetricsApi.listTagConfigurations", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricsAndMetricTagConfigurationsResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricsAndMetricTagConfigurationsResponse>> listTagConfigurationsWithHttpInfoAsync(ListTagConfigurationsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Boolean filterConfigured = parameters.filterConfigured;
        String filterTagsConfigured = parameters.filterTagsConfigured;
        MetricTagConfigurationMetricTypes filterMetricType = parameters.filterMetricType;
        Boolean filterIncludePercentiles = parameters.filterIncludePercentiles;
        String filterTags = parameters.filterTags;
        Long windowSeconds = parameters.windowSeconds;
        String localVarPath = "/api/v2/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[configured]", filterConfigured));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags_configured]", filterTagsConfigured));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[metric_type]", filterMetricType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[include_percentiles]", filterIncludePercentiles));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "window[seconds]", windowSeconds));
        try {
            builder = this.apiClient.createBuilder("MetricsApi.listTagConfigurations", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricsAndMetricTagConfigurationsResponse>> result = new CompletableFuture<ApiResponse<MetricsAndMetricTagConfigurationsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricsAndMetricTagConfigurationsResponse>(){});
    }

    public MetricAllTagsResponse listTagsByMetricName(String metricName) throws ApiException {
        return this.listTagsByMetricNameWithHttpInfo(metricName).getData();
    }

    public CompletableFuture<MetricAllTagsResponse> listTagsByMetricNameAsync(String metricName) {
        return this.listTagsByMetricNameWithHttpInfoAsync(metricName).thenApply(response -> (MetricAllTagsResponse)response.getData());
    }

    public ApiResponse<MetricAllTagsResponse> listTagsByMetricNameWithHttpInfo(String metricName) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling listTagsByMetricName");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/all-tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("MetricsApi.listTagsByMetricName", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricAllTagsResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricAllTagsResponse>> listTagsByMetricNameWithHttpInfoAsync(String metricName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricName == null) {
            CompletableFuture<ApiResponse<MetricAllTagsResponse>> result = new CompletableFuture<ApiResponse<MetricAllTagsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricName' when calling listTagsByMetricName"));
            return result;
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/all-tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("MetricsApi.listTagsByMetricName", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricAllTagsResponse>> result = new CompletableFuture<ApiResponse<MetricAllTagsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricAllTagsResponse>(){});
    }

    public MetricVolumesResponse listVolumesByMetricName(String metricName) throws ApiException {
        return this.listVolumesByMetricNameWithHttpInfo(metricName).getData();
    }

    public CompletableFuture<MetricVolumesResponse> listVolumesByMetricNameAsync(String metricName) {
        return this.listVolumesByMetricNameWithHttpInfoAsync(metricName).thenApply(response -> (MetricVolumesResponse)response.getData());
    }

    public ApiResponse<MetricVolumesResponse> listVolumesByMetricNameWithHttpInfo(String metricName) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling listVolumesByMetricName");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/volumes".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("MetricsApi.listVolumesByMetricName", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricVolumesResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricVolumesResponse>> listVolumesByMetricNameWithHttpInfoAsync(String metricName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (metricName == null) {
            CompletableFuture<ApiResponse<MetricVolumesResponse>> result = new CompletableFuture<ApiResponse<MetricVolumesResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricName' when calling listVolumesByMetricName"));
            return result;
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/volumes".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("MetricsApi.listVolumesByMetricName", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricVolumesResponse>> result = new CompletableFuture<ApiResponse<MetricVolumesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricVolumesResponse>(){});
    }

    public IntakePayloadAccepted submitMetrics(MetricPayload body) throws ApiException {
        return this.submitMetricsWithHttpInfo(body, new SubmitMetricsOptionalParameters()).getData();
    }

    public CompletableFuture<IntakePayloadAccepted> submitMetricsAsync(MetricPayload body) {
        return this.submitMetricsWithHttpInfoAsync(body, new SubmitMetricsOptionalParameters()).thenApply(response -> (IntakePayloadAccepted)response.getData());
    }

    public IntakePayloadAccepted submitMetrics(MetricPayload body, SubmitMetricsOptionalParameters parameters) throws ApiException {
        return this.submitMetricsWithHttpInfo(body, parameters).getData();
    }

    public CompletableFuture<IntakePayloadAccepted> submitMetricsAsync(MetricPayload body, SubmitMetricsOptionalParameters parameters) {
        return this.submitMetricsWithHttpInfoAsync(body, parameters).thenApply(response -> (IntakePayloadAccepted)response.getData());
    }

    public ApiResponse<IntakePayloadAccepted> submitMetricsWithHttpInfo(MetricPayload body, SubmitMetricsOptionalParameters parameters) throws ApiException {
        MetricPayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling submitMetrics");
        }
        MetricContentEncoding contentEncoding = parameters.contentEncoding;
        String localVarPath = "/api/v2/series";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString(contentEncoding));
        }
        Invocation.Builder builder = this.apiClient.createBuilder("MetricsApi.submitMetrics", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IntakePayloadAccepted>(){});
    }

    public CompletableFuture<ApiResponse<IntakePayloadAccepted>> submitMetricsWithHttpInfoAsync(MetricPayload body, SubmitMetricsOptionalParameters parameters) {
        Invocation.Builder builder;
        MetricPayload localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IntakePayloadAccepted>> result = new CompletableFuture<ApiResponse<IntakePayloadAccepted>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling submitMetrics"));
            return result;
        }
        MetricContentEncoding contentEncoding = parameters.contentEncoding;
        String localVarPath = "/api/v2/series";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString(contentEncoding));
        }
        try {
            builder = this.apiClient.createBuilder("MetricsApi.submitMetrics", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IntakePayloadAccepted>> result = new CompletableFuture<ApiResponse<IntakePayloadAccepted>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IntakePayloadAccepted>(){});
    }

    public MetricTagConfigurationResponse updateTagConfiguration(String metricName, MetricTagConfigurationUpdateRequest body) throws ApiException {
        return this.updateTagConfigurationWithHttpInfo(metricName, body).getData();
    }

    public CompletableFuture<MetricTagConfigurationResponse> updateTagConfigurationAsync(String metricName, MetricTagConfigurationUpdateRequest body) {
        return this.updateTagConfigurationWithHttpInfoAsync(metricName, body).thenApply(response -> (MetricTagConfigurationResponse)response.getData());
    }

    public ApiResponse<MetricTagConfigurationResponse> updateTagConfigurationWithHttpInfo(String metricName, MetricTagConfigurationUpdateRequest body) throws ApiException {
        MetricTagConfigurationUpdateRequest localVarPostBody = body;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling updateTagConfiguration");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTagConfiguration");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("MetricsApi.updateTagConfiguration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricTagConfigurationResponse>(){});
    }

    public CompletableFuture<ApiResponse<MetricTagConfigurationResponse>> updateTagConfigurationWithHttpInfoAsync(String metricName, MetricTagConfigurationUpdateRequest body) {
        Invocation.Builder builder;
        MetricTagConfigurationUpdateRequest localVarPostBody = body;
        if (metricName == null) {
            CompletableFuture<ApiResponse<MetricTagConfigurationResponse>> result = new CompletableFuture<ApiResponse<MetricTagConfigurationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'metricName' when calling updateTagConfiguration"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<MetricTagConfigurationResponse>> result = new CompletableFuture<ApiResponse<MetricTagConfigurationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateTagConfiguration"));
            return result;
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("MetricsApi.updateTagConfiguration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MetricTagConfigurationResponse>> result = new CompletableFuture<ApiResponse<MetricTagConfigurationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MetricTagConfigurationResponse>(){});
    }

    public static class SubmitMetricsOptionalParameters {
        private MetricContentEncoding contentEncoding;

        public SubmitMetricsOptionalParameters contentEncoding(MetricContentEncoding contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }
    }

    public static class ListTagConfigurationsOptionalParameters {
        private Boolean filterConfigured;
        private String filterTagsConfigured;
        private MetricTagConfigurationMetricTypes filterMetricType;
        private Boolean filterIncludePercentiles;
        private String filterTags;
        private Long windowSeconds;

        public ListTagConfigurationsOptionalParameters filterConfigured(Boolean filterConfigured) {
            this.filterConfigured = filterConfigured;
            return this;
        }

        public ListTagConfigurationsOptionalParameters filterTagsConfigured(String filterTagsConfigured) {
            this.filterTagsConfigured = filterTagsConfigured;
            return this;
        }

        public ListTagConfigurationsOptionalParameters filterMetricType(MetricTagConfigurationMetricTypes filterMetricType) {
            this.filterMetricType = filterMetricType;
            return this;
        }

        public ListTagConfigurationsOptionalParameters filterIncludePercentiles(Boolean filterIncludePercentiles) {
            this.filterIncludePercentiles = filterIncludePercentiles;
            return this;
        }

        public ListTagConfigurationsOptionalParameters filterTags(String filterTags) {
            this.filterTags = filterTags;
            return this;
        }

        public ListTagConfigurationsOptionalParameters windowSeconds(Long windowSeconds) {
            this.windowSeconds = windowSeconds;
            return this;
        }
    }

    public static class EstimateMetricsOutputSeriesOptionalParameters {
        private String filterGroups;
        private Integer filterHoursAgo;
        private Integer filterNumAggregations;
        private Boolean filterPct;
        private Integer filterTimespanH;

        public EstimateMetricsOutputSeriesOptionalParameters filterGroups(String filterGroups) {
            this.filterGroups = filterGroups;
            return this;
        }

        public EstimateMetricsOutputSeriesOptionalParameters filterHoursAgo(Integer filterHoursAgo) {
            this.filterHoursAgo = filterHoursAgo;
            return this;
        }

        public EstimateMetricsOutputSeriesOptionalParameters filterNumAggregations(Integer filterNumAggregations) {
            this.filterNumAggregations = filterNumAggregations;
            return this;
        }

        public EstimateMetricsOutputSeriesOptionalParameters filterPct(Boolean filterPct) {
            this.filterPct = filterPct;
            return this;
        }

        public EstimateMetricsOutputSeriesOptionalParameters filterTimespanH(Integer filterTimespanH) {
            this.filterTimespanH = filterTimespanH;
            return this;
        }
    }
}

