/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=RUMEventTypeSerializer.class)
public class RUMEventType {
    public static final RUMEventType RUM = new RUMEventType("rum");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("rum"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    RUMEventType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((RUMEventType)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static RUMEventType fromValue(String value) {
        return new RUMEventType(value);
    }

    public static class RUMEventTypeSerializer
    extends StdSerializer<RUMEventType> {
        public RUMEventTypeSerializer(Class<RUMEventType> t) {
            super(t);
        }

        public RUMEventTypeSerializer() {
            this(null);
        }

        public void serialize(RUMEventType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

