/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CIAppPipelinesQueryFilter;
import com.datadog.api.client.v2.model.CIAppQueryOptions;
import com.datadog.api.client.v2.model.CIAppQueryPageOptions;
import com.datadog.api.client.v2.model.CIAppSort;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"filter", "options", "page", "sort"})
public class CIAppPipelineEventsRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private CIAppPipelinesQueryFilter filter;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private CIAppQueryOptions options;
    public static final String JSON_PROPERTY_PAGE = "page";
    private CIAppQueryPageOptions page;
    public static final String JSON_PROPERTY_SORT = "sort";
    private CIAppSort sort;
    private Map<String, Object> additionalProperties;

    public CIAppPipelineEventsRequest filter(CIAppPipelinesQueryFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppPipelinesQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(CIAppPipelinesQueryFilter filter) {
        this.filter = filter;
    }

    public CIAppPipelineEventsRequest options(CIAppQueryOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppQueryOptions getOptions() {
        return this.options;
    }

    public void setOptions(CIAppQueryOptions options) {
        this.options = options;
    }

    public CIAppPipelineEventsRequest page(CIAppQueryPageOptions page) {
        this.page = page;
        this.unparsed |= page.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppQueryPageOptions getPage() {
        return this.page;
    }

    public void setPage(CIAppQueryPageOptions page) {
        this.page = page;
    }

    public CIAppPipelineEventsRequest sort(CIAppSort sort) {
        this.sort = sort;
        this.unparsed |= !sort.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppSort getSort() {
        return this.sort;
    }

    public void setSort(CIAppSort sort) {
        if (!sort.isValid()) {
            this.unparsed = true;
        }
        this.sort = sort;
    }

    @JsonAnySetter
    public CIAppPipelineEventsRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CIAppPipelineEventsRequest ciAppPipelineEventsRequest = (CIAppPipelineEventsRequest)o;
        return Objects.equals(this.filter, ciAppPipelineEventsRequest.filter) && Objects.equals(this.options, ciAppPipelineEventsRequest.options) && Objects.equals(this.page, ciAppPipelineEventsRequest.page) && Objects.equals(this.sort, ciAppPipelineEventsRequest.sort) && Objects.equals(this.additionalProperties, ciAppPipelineEventsRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.options, this.page, this.sort, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CIAppPipelineEventsRequest {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

