/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CloudConfigurationRuleComplianceSignalOptions;
import com.datadog.api.client.v2.model.SecurityMonitoringFilter;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleCase;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleOptions;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleQuery;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"cases", "complianceSignalOptions", "filters", "hasExtendedTitle", "isEnabled", "message", "name", "options", "queries", "tags", "version"})
public class SecurityMonitoringRuleUpdatePayload {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CASES = "cases";
    private List<SecurityMonitoringRuleCase> cases = null;
    public static final String JSON_PROPERTY_COMPLIANCE_SIGNAL_OPTIONS = "complianceSignalOptions";
    private CloudConfigurationRuleComplianceSignalOptions complianceSignalOptions;
    public static final String JSON_PROPERTY_FILTERS = "filters";
    private List<SecurityMonitoringFilter> filters = null;
    public static final String JSON_PROPERTY_HAS_EXTENDED_TITLE = "hasExtendedTitle";
    private Boolean hasExtendedTitle;
    public static final String JSON_PROPERTY_IS_ENABLED = "isEnabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private SecurityMonitoringRuleOptions options;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<SecurityMonitoringRuleQuery> queries = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    private Map<String, Object> additionalProperties;

    public SecurityMonitoringRuleUpdatePayload cases(List<SecurityMonitoringRuleCase> cases) {
        this.cases = cases;
        for (SecurityMonitoringRuleCase item : cases) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityMonitoringRuleUpdatePayload addCasesItem(SecurityMonitoringRuleCase casesItem) {
        if (this.cases == null) {
            this.cases = new ArrayList<SecurityMonitoringRuleCase>();
        }
        this.cases.add(casesItem);
        this.unparsed |= casesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="cases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityMonitoringRuleCase> getCases() {
        return this.cases;
    }

    public void setCases(List<SecurityMonitoringRuleCase> cases) {
        this.cases = cases;
    }

    public SecurityMonitoringRuleUpdatePayload complianceSignalOptions(CloudConfigurationRuleComplianceSignalOptions complianceSignalOptions) {
        this.complianceSignalOptions = complianceSignalOptions;
        this.unparsed |= complianceSignalOptions.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="complianceSignalOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CloudConfigurationRuleComplianceSignalOptions getComplianceSignalOptions() {
        return this.complianceSignalOptions;
    }

    public void setComplianceSignalOptions(CloudConfigurationRuleComplianceSignalOptions complianceSignalOptions) {
        this.complianceSignalOptions = complianceSignalOptions;
    }

    public SecurityMonitoringRuleUpdatePayload filters(List<SecurityMonitoringFilter> filters) {
        this.filters = filters;
        for (SecurityMonitoringFilter item : filters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityMonitoringRuleUpdatePayload addFiltersItem(SecurityMonitoringFilter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<SecurityMonitoringFilter>();
        }
        this.filters.add(filtersItem);
        this.unparsed |= filtersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityMonitoringFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<SecurityMonitoringFilter> filters) {
        this.filters = filters;
    }

    public SecurityMonitoringRuleUpdatePayload hasExtendedTitle(Boolean hasExtendedTitle) {
        this.hasExtendedTitle = hasExtendedTitle;
        return this;
    }

    @Nullable
    @JsonProperty(value="hasExtendedTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasExtendedTitle() {
        return this.hasExtendedTitle;
    }

    public void setHasExtendedTitle(Boolean hasExtendedTitle) {
        this.hasExtendedTitle = hasExtendedTitle;
    }

    public SecurityMonitoringRuleUpdatePayload isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="isEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public SecurityMonitoringRuleUpdatePayload message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SecurityMonitoringRuleUpdatePayload name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityMonitoringRuleUpdatePayload options(SecurityMonitoringRuleOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleOptions getOptions() {
        return this.options;
    }

    public void setOptions(SecurityMonitoringRuleOptions options) {
        this.options = options;
    }

    public SecurityMonitoringRuleUpdatePayload queries(List<SecurityMonitoringRuleQuery> queries) {
        this.queries = queries;
        for (SecurityMonitoringRuleQuery item : queries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SecurityMonitoringRuleUpdatePayload addQueriesItem(SecurityMonitoringRuleQuery queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<SecurityMonitoringRuleQuery>();
        }
        this.queries.add(queriesItem);
        this.unparsed |= queriesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SecurityMonitoringRuleQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<SecurityMonitoringRuleQuery> queries) {
        this.queries = queries;
    }

    public SecurityMonitoringRuleUpdatePayload tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SecurityMonitoringRuleUpdatePayload addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public SecurityMonitoringRuleUpdatePayload version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonAnySetter
    public SecurityMonitoringRuleUpdatePayload putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuleUpdatePayload securityMonitoringRuleUpdatePayload = (SecurityMonitoringRuleUpdatePayload)o;
        return Objects.equals(this.cases, securityMonitoringRuleUpdatePayload.cases) && Objects.equals(this.complianceSignalOptions, securityMonitoringRuleUpdatePayload.complianceSignalOptions) && Objects.equals(this.filters, securityMonitoringRuleUpdatePayload.filters) && Objects.equals(this.hasExtendedTitle, securityMonitoringRuleUpdatePayload.hasExtendedTitle) && Objects.equals(this.isEnabled, securityMonitoringRuleUpdatePayload.isEnabled) && Objects.equals(this.message, securityMonitoringRuleUpdatePayload.message) && Objects.equals(this.name, securityMonitoringRuleUpdatePayload.name) && Objects.equals(this.options, securityMonitoringRuleUpdatePayload.options) && Objects.equals(this.queries, securityMonitoringRuleUpdatePayload.queries) && Objects.equals(this.tags, securityMonitoringRuleUpdatePayload.tags) && Objects.equals(this.version, securityMonitoringRuleUpdatePayload.version) && Objects.equals(this.additionalProperties, securityMonitoringRuleUpdatePayload.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.cases, this.complianceSignalOptions, this.filters, this.hasExtendedTitle, this.isEnabled, this.message, this.name, this.options, this.queries, this.tags, this.version, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuleUpdatePayload {\n");
        sb.append("    cases: ").append(this.toIndentedString(this.cases)).append("\n");
        sb.append("    complianceSignalOptions: ").append(this.toIndentedString(this.complianceSignalOptions)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    hasExtendedTitle: ").append(this.toIndentedString(this.hasExtendedTitle)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

