/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SLOListResponseMetadata;
import com.datadog.api.client.v1.model.ServiceLevelObjective;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "errors", "metadata"})
public class SLOListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<ServiceLevelObjective> data = null;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<String> errors = null;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private SLOListResponseMetadata metadata;
    private Map<String, Object> additionalProperties;

    public SLOListResponse data(List<ServiceLevelObjective> data) {
        this.data = data;
        for (ServiceLevelObjective item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SLOListResponse addDataItem(ServiceLevelObjective dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<ServiceLevelObjective>();
        }
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ServiceLevelObjective> getData() {
        return this.data;
    }

    public void setData(List<ServiceLevelObjective> data) {
        this.data = data;
    }

    public SLOListResponse errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public SLOListResponse addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public SLOListResponse metadata(SLOListResponseMetadata metadata) {
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOListResponseMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(SLOListResponseMetadata metadata) {
        this.metadata = metadata;
    }

    @JsonAnySetter
    public SLOListResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOListResponse sloListResponse = (SLOListResponse)o;
        return Objects.equals(this.data, sloListResponse.data) && Objects.equals(this.errors, sloListResponse.errors) && Objects.equals(this.metadata, sloListResponse.metadata) && Objects.equals(this.additionalProperties, sloListResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.errors, this.metadata, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOListResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

