/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.State;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"remarks", "rule_id", "service_name", "state"})
public class OutcomesBatchRequestItem {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_REMARKS = "remarks";
    private String remarks;
    public static final String JSON_PROPERTY_RULE_ID = "rule_id";
    private String ruleId;
    public static final String JSON_PROPERTY_SERVICE_NAME = "service_name";
    private String serviceName;
    public static final String JSON_PROPERTY_STATE = "state";
    private State state;
    private Map<String, Object> additionalProperties;

    public OutcomesBatchRequestItem() {
    }

    @JsonCreator
    public OutcomesBatchRequestItem(@JsonProperty(required=true, value="rule_id") String ruleId, @JsonProperty(required=true, value="service_name") String serviceName, @JsonProperty(required=true, value="state") State state) {
        this.ruleId = ruleId;
        this.serviceName = serviceName;
        this.state = state;
        this.unparsed |= !state.isValid();
    }

    public OutcomesBatchRequestItem remarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    @Nullable
    @JsonProperty(value="remarks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public OutcomesBatchRequestItem ruleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @JsonProperty(value="rule_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public OutcomesBatchRequestItem serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @JsonProperty(value="service_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public OutcomesBatchRequestItem state(State state) {
        this.state = state;
        this.unparsed |= !state.isValid();
        return this;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        if (!state.isValid()) {
            this.unparsed = true;
        }
        this.state = state;
    }

    @JsonAnySetter
    public OutcomesBatchRequestItem putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutcomesBatchRequestItem outcomesBatchRequestItem = (OutcomesBatchRequestItem)o;
        return Objects.equals(this.remarks, outcomesBatchRequestItem.remarks) && Objects.equals(this.ruleId, outcomesBatchRequestItem.ruleId) && Objects.equals(this.serviceName, outcomesBatchRequestItem.serviceName) && Objects.equals(this.state, outcomesBatchRequestItem.state) && Objects.equals(this.additionalProperties, outcomesBatchRequestItem.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.remarks, this.ruleId, this.serviceName, this.state, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutcomesBatchRequestItem {\n");
        sb.append("    remarks: ").append(this.toIndentedString(this.remarks)).append("\n");
        sb.append("    ruleId: ").append(this.toIndentedString(this.ruleId)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

