/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SLOSliSpec;
import com.datadog.api.client.v1.model.SLOThreshold;
import com.datadog.api.client.v1.model.SLOTimeframe;
import com.datadog.api.client.v1.model.SLOType;
import com.datadog.api.client.v1.model.ServiceLevelObjectiveQuery;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"description", "groups", "monitor_ids", "name", "query", "sli_specification", "tags", "target_threshold", "thresholds", "timeframe", "type", "warning_threshold"})
public class ServiceLevelObjectiveRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_GROUPS = "groups";
    private List<String> groups = null;
    public static final String JSON_PROPERTY_MONITOR_IDS = "monitor_ids";
    private List<Long> monitorIds = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private ServiceLevelObjectiveQuery query;
    public static final String JSON_PROPERTY_SLI_SPECIFICATION = "sli_specification";
    private SLOSliSpec sliSpecification;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TARGET_THRESHOLD = "target_threshold";
    private Double targetThreshold;
    public static final String JSON_PROPERTY_THRESHOLDS = "thresholds";
    private List<SLOThreshold> thresholds = new ArrayList<SLOThreshold>();
    public static final String JSON_PROPERTY_TIMEFRAME = "timeframe";
    private SLOTimeframe timeframe;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SLOType type;
    public static final String JSON_PROPERTY_WARNING_THRESHOLD = "warning_threshold";
    private Double warningThreshold;
    private Map<String, Object> additionalProperties;

    public ServiceLevelObjectiveRequest() {
    }

    @JsonCreator
    public ServiceLevelObjectiveRequest(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="thresholds") List<SLOThreshold> thresholds, @JsonProperty(required=true, value="type") SLOType type) {
        this.name = name;
        this.thresholds = thresholds;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public ServiceLevelObjectiveRequest description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public ServiceLevelObjectiveRequest groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public ServiceLevelObjectiveRequest addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public ServiceLevelObjectiveRequest monitorIds(List<Long> monitorIds) {
        this.monitorIds = monitorIds;
        return this;
    }

    public ServiceLevelObjectiveRequest addMonitorIdsItem(Long monitorIdsItem) {
        if (this.monitorIds == null) {
            this.monitorIds = new ArrayList<Long>();
        }
        this.monitorIds.add(monitorIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="monitor_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getMonitorIds() {
        return this.monitorIds;
    }

    public void setMonitorIds(List<Long> monitorIds) {
        this.monitorIds = monitorIds;
    }

    public ServiceLevelObjectiveRequest name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceLevelObjectiveRequest query(ServiceLevelObjectiveQuery query) {
        this.query = query;
        this.unparsed |= query.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceLevelObjectiveQuery getQuery() {
        return this.query;
    }

    public void setQuery(ServiceLevelObjectiveQuery query) {
        this.query = query;
    }

    public ServiceLevelObjectiveRequest sliSpecification(SLOSliSpec sliSpecification) {
        this.sliSpecification = sliSpecification;
        this.unparsed |= sliSpecification.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="sli_specification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOSliSpec getSliSpecification() {
        return this.sliSpecification;
    }

    public void setSliSpecification(SLOSliSpec sliSpecification) {
        this.sliSpecification = sliSpecification;
    }

    public ServiceLevelObjectiveRequest tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ServiceLevelObjectiveRequest addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ServiceLevelObjectiveRequest targetThreshold(Double targetThreshold) {
        this.targetThreshold = targetThreshold;
        return this;
    }

    @Nullable
    @JsonProperty(value="target_threshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTargetThreshold() {
        return this.targetThreshold;
    }

    public void setTargetThreshold(Double targetThreshold) {
        this.targetThreshold = targetThreshold;
    }

    public ServiceLevelObjectiveRequest thresholds(List<SLOThreshold> thresholds) {
        this.thresholds = thresholds;
        for (SLOThreshold item : thresholds) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ServiceLevelObjectiveRequest addThresholdsItem(SLOThreshold thresholdsItem) {
        this.thresholds.add(thresholdsItem);
        this.unparsed |= thresholdsItem.unparsed;
        return this;
    }

    @JsonProperty(value="thresholds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SLOThreshold> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(List<SLOThreshold> thresholds) {
        this.thresholds = thresholds;
    }

    public ServiceLevelObjectiveRequest timeframe(SLOTimeframe timeframe) {
        this.timeframe = timeframe;
        this.unparsed |= !timeframe.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="timeframe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOTimeframe getTimeframe() {
        return this.timeframe;
    }

    public void setTimeframe(SLOTimeframe timeframe) {
        if (!timeframe.isValid()) {
            this.unparsed = true;
        }
        this.timeframe = timeframe;
    }

    public ServiceLevelObjectiveRequest type(SLOType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SLOType getType() {
        return this.type;
    }

    public void setType(SLOType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public ServiceLevelObjectiveRequest warningThreshold(Double warningThreshold) {
        this.warningThreshold = warningThreshold;
        return this;
    }

    @Nullable
    @JsonProperty(value="warning_threshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getWarningThreshold() {
        return this.warningThreshold;
    }

    public void setWarningThreshold(Double warningThreshold) {
        this.warningThreshold = warningThreshold;
    }

    @JsonAnySetter
    public ServiceLevelObjectiveRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceLevelObjectiveRequest serviceLevelObjectiveRequest = (ServiceLevelObjectiveRequest)o;
        return Objects.equals(this.description, serviceLevelObjectiveRequest.description) && Objects.equals(this.groups, serviceLevelObjectiveRequest.groups) && Objects.equals(this.monitorIds, serviceLevelObjectiveRequest.monitorIds) && Objects.equals(this.name, serviceLevelObjectiveRequest.name) && Objects.equals(this.query, serviceLevelObjectiveRequest.query) && Objects.equals(this.sliSpecification, serviceLevelObjectiveRequest.sliSpecification) && Objects.equals(this.tags, serviceLevelObjectiveRequest.tags) && Objects.equals(this.targetThreshold, serviceLevelObjectiveRequest.targetThreshold) && Objects.equals(this.thresholds, serviceLevelObjectiveRequest.thresholds) && Objects.equals(this.timeframe, serviceLevelObjectiveRequest.timeframe) && Objects.equals(this.type, serviceLevelObjectiveRequest.type) && Objects.equals(this.warningThreshold, serviceLevelObjectiveRequest.warningThreshold) && Objects.equals(this.additionalProperties, serviceLevelObjectiveRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.groups, this.monitorIds, this.name, this.query, this.sliSpecification, this.tags, this.targetThreshold, this.thresholds, this.timeframe, this.type, this.warningThreshold, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceLevelObjectiveRequest {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    monitorIds: ").append(this.toIndentedString(this.monitorIds)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    sliSpecification: ").append(this.toIndentedString(this.sliSpecification)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    targetThreshold: ").append(this.toIndentedString(this.targetThreshold)).append("\n");
        sb.append("    thresholds: ").append(this.toIndentedString(this.thresholds)).append("\n");
        sb.append("    timeframe: ").append(this.toIndentedString(this.timeframe)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    warningThreshold: ").append(this.toIndentedString(this.warningThreshold)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

