/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.ServiceMapWidgetDefinitionType;
import com.datadog.api.client.v1.model.WidgetCustomLink;
import com.datadog.api.client.v1.model.WidgetTextAlign;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"custom_links", "filters", "service", "title", "title_align", "title_size", "type"})
public class ServiceMapWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_FILTERS = "filters";
    private List<String> filters = new ArrayList<String>();
    public static final String JSON_PROPERTY_SERVICE = "service";
    private String service;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ServiceMapWidgetDefinitionType type = ServiceMapWidgetDefinitionType.SERVICEMAP;
    private Map<String, Object> additionalProperties;

    public ServiceMapWidgetDefinition() {
    }

    @JsonCreator
    public ServiceMapWidgetDefinition(@JsonProperty(required=true, value="filters") List<String> filters, @JsonProperty(required=true, value="service") String service, @JsonProperty(required=true, value="type") ServiceMapWidgetDefinitionType type) {
        this.filters = filters;
        this.service = service;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public ServiceMapWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        for (WidgetCustomLink item : customLinks) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ServiceMapWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        this.unparsed |= customLinksItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public ServiceMapWidgetDefinition filters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    public ServiceMapWidgetDefinition addFiltersItem(String filtersItem) {
        this.filters.add(filtersItem);
        return this;
    }

    @JsonProperty(value="filters")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public ServiceMapWidgetDefinition service(String service) {
        this.service = service;
        return this;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public ServiceMapWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ServiceMapWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public ServiceMapWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public ServiceMapWidgetDefinition type(ServiceMapWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceMapWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(ServiceMapWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public ServiceMapWidgetDefinition putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceMapWidgetDefinition serviceMapWidgetDefinition = (ServiceMapWidgetDefinition)o;
        return Objects.equals(this.customLinks, serviceMapWidgetDefinition.customLinks) && Objects.equals(this.filters, serviceMapWidgetDefinition.filters) && Objects.equals(this.service, serviceMapWidgetDefinition.service) && Objects.equals(this.title, serviceMapWidgetDefinition.title) && Objects.equals(this.titleAlign, serviceMapWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, serviceMapWidgetDefinition.titleSize) && Objects.equals(this.type, serviceMapWidgetDefinition.type) && Objects.equals(this.additionalProperties, serviceMapWidgetDefinition.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.customLinks, this.filters, this.service, this.title, this.titleAlign, this.titleSize, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceMapWidgetDefinition {\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

