/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"avatar", "banner", "description", "handle", "hidden_modules", "name", "visible_modules"})
public class TeamCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AVATAR = "avatar";
    private JsonNullable<String> avatar = JsonNullable.undefined();
    public static final String JSON_PROPERTY_BANNER = "banner";
    private JsonNullable<Long> banner = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_HANDLE = "handle";
    private String handle;
    public static final String JSON_PROPERTY_HIDDEN_MODULES = "hidden_modules";
    private List<String> hiddenModules = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_VISIBLE_MODULES = "visible_modules";
    private List<String> visibleModules = null;
    private Map<String, Object> additionalProperties;

    public TeamCreateAttributes() {
    }

    @JsonCreator
    public TeamCreateAttributes(@JsonProperty(required=true, value="handle") String handle, @JsonProperty(required=true, value="name") String name) {
        this.handle = handle;
        this.name = name;
    }

    public TeamCreateAttributes avatar(String avatar) {
        this.avatar = JsonNullable.of((Object)avatar);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getAvatar() {
        return (String)this.avatar.orElse(null);
    }

    @JsonProperty(value="avatar")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAvatar_JsonNullable() {
        return this.avatar;
    }

    @JsonProperty(value="avatar")
    public void setAvatar_JsonNullable(JsonNullable<String> avatar) {
        this.avatar = avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = JsonNullable.of((Object)avatar);
    }

    public TeamCreateAttributes banner(Long banner) {
        this.banner = JsonNullable.of((Object)banner);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getBanner() {
        return (Long)this.banner.orElse(null);
    }

    @JsonProperty(value="banner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getBanner_JsonNullable() {
        return this.banner;
    }

    @JsonProperty(value="banner")
    public void setBanner_JsonNullable(JsonNullable<Long> banner) {
        this.banner = banner;
    }

    public void setBanner(Long banner) {
        this.banner = JsonNullable.of((Object)banner);
    }

    public TeamCreateAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TeamCreateAttributes handle(String handle) {
        this.handle = handle;
        return this;
    }

    @JsonProperty(value="handle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public TeamCreateAttributes hiddenModules(List<String> hiddenModules) {
        this.hiddenModules = hiddenModules;
        return this;
    }

    public TeamCreateAttributes addHiddenModulesItem(String hiddenModulesItem) {
        if (this.hiddenModules == null) {
            this.hiddenModules = new ArrayList<String>();
        }
        this.hiddenModules.add(hiddenModulesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="hidden_modules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHiddenModules() {
        return this.hiddenModules;
    }

    public void setHiddenModules(List<String> hiddenModules) {
        this.hiddenModules = hiddenModules;
    }

    public TeamCreateAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TeamCreateAttributes visibleModules(List<String> visibleModules) {
        this.visibleModules = visibleModules;
        return this;
    }

    public TeamCreateAttributes addVisibleModulesItem(String visibleModulesItem) {
        if (this.visibleModules == null) {
            this.visibleModules = new ArrayList<String>();
        }
        this.visibleModules.add(visibleModulesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="visible_modules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getVisibleModules() {
        return this.visibleModules;
    }

    public void setVisibleModules(List<String> visibleModules) {
        this.visibleModules = visibleModules;
    }

    @JsonAnySetter
    public TeamCreateAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamCreateAttributes teamCreateAttributes = (TeamCreateAttributes)o;
        return Objects.equals(this.avatar, teamCreateAttributes.avatar) && Objects.equals(this.banner, teamCreateAttributes.banner) && Objects.equals(this.description, teamCreateAttributes.description) && Objects.equals(this.handle, teamCreateAttributes.handle) && Objects.equals(this.hiddenModules, teamCreateAttributes.hiddenModules) && Objects.equals(this.name, teamCreateAttributes.name) && Objects.equals(this.visibleModules, teamCreateAttributes.visibleModules) && Objects.equals(this.additionalProperties, teamCreateAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.avatar, this.banner, this.description, this.handle, this.hiddenModules, this.name, this.visibleModules, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamCreateAttributes {\n");
        sb.append("    avatar: ").append(this.toIndentedString(this.avatar)).append("\n");
        sb.append("    banner: ").append(this.toIndentedString(this.banner)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    handle: ").append(this.toIndentedString(this.handle)).append("\n");
        sb.append("    hiddenModules: ").append(this.toIndentedString(this.hiddenModules)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    visibleModules: ").append(this.toIndentedString(this.visibleModules)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

