/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.DashboardList;
import com.datadog.api.client.v1.model.DashboardListDeleteResponse;
import com.datadog.api.client.v1.model.DashboardListListResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class DashboardListsApi {
    private ApiClient apiClient;

    public DashboardListsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public DashboardListsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DashboardList createDashboardList(DashboardList body) throws ApiException {
        return this.createDashboardListWithHttpInfo(body).getData();
    }

    public CompletableFuture<DashboardList> createDashboardListAsync(DashboardList body) {
        return this.createDashboardListWithHttpInfoAsync(body).thenApply(response -> (DashboardList)response.getData());
    }

    public ApiResponse<DashboardList> createDashboardListWithHttpInfo(DashboardList body) throws ApiException {
        DashboardList localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardListsApi.createDashboardList", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardList>(){});
    }

    public CompletableFuture<ApiResponse<DashboardList>> createDashboardListWithHttpInfoAsync(DashboardList body) {
        Invocation.Builder builder;
        DashboardList localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DashboardList>> result = new CompletableFuture<ApiResponse<DashboardList>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDashboardList"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/lists/manual";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("DashboardListsApi.createDashboardList", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardList>> result = new CompletableFuture<ApiResponse<DashboardList>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardList>(){});
    }

    public DashboardListDeleteResponse deleteDashboardList(Long listId) throws ApiException {
        return this.deleteDashboardListWithHttpInfo(listId).getData();
    }

    public CompletableFuture<DashboardListDeleteResponse> deleteDashboardListAsync(Long listId) {
        return this.deleteDashboardListWithHttpInfoAsync(listId).thenApply(response -> (DashboardListDeleteResponse)response.getData());
    }

    public ApiResponse<DashboardListDeleteResponse> deleteDashboardListWithHttpInfo(Long listId) throws ApiException {
        Object localVarPostBody = null;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling deleteDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardListsApi.deleteDashboardList", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListDeleteResponse>(){});
    }

    public CompletableFuture<ApiResponse<DashboardListDeleteResponse>> deleteDashboardListWithHttpInfoAsync(Long listId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (listId == null) {
            CompletableFuture<ApiResponse<DashboardListDeleteResponse>> result = new CompletableFuture<ApiResponse<DashboardListDeleteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'listId' when calling deleteDashboardList"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("DashboardListsApi.deleteDashboardList", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardListDeleteResponse>> result = new CompletableFuture<ApiResponse<DashboardListDeleteResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListDeleteResponse>(){});
    }

    public DashboardList getDashboardList(Long listId) throws ApiException {
        return this.getDashboardListWithHttpInfo(listId).getData();
    }

    public CompletableFuture<DashboardList> getDashboardListAsync(Long listId) {
        return this.getDashboardListWithHttpInfoAsync(listId).thenApply(response -> (DashboardList)response.getData());
    }

    public ApiResponse<DashboardList> getDashboardListWithHttpInfo(Long listId) throws ApiException {
        Object localVarPostBody = null;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling getDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardListsApi.getDashboardList", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardList>(){});
    }

    public CompletableFuture<ApiResponse<DashboardList>> getDashboardListWithHttpInfoAsync(Long listId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (listId == null) {
            CompletableFuture<ApiResponse<DashboardList>> result = new CompletableFuture<ApiResponse<DashboardList>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'listId' when calling getDashboardList"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("DashboardListsApi.getDashboardList", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardList>> result = new CompletableFuture<ApiResponse<DashboardList>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardList>(){});
    }

    public DashboardListListResponse listDashboardLists() throws ApiException {
        return this.listDashboardListsWithHttpInfo().getData();
    }

    public CompletableFuture<DashboardListListResponse> listDashboardListsAsync() {
        return this.listDashboardListsWithHttpInfoAsync().thenApply(response -> (DashboardListListResponse)response.getData());
    }

    public ApiResponse<DashboardListListResponse> listDashboardListsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/dashboard/lists/manual";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardListsApi.listDashboardLists", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListListResponse>(){});
    }

    public CompletableFuture<ApiResponse<DashboardListListResponse>> listDashboardListsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/dashboard/lists/manual";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("DashboardListsApi.listDashboardLists", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardListListResponse>> result = new CompletableFuture<ApiResponse<DashboardListListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardListListResponse>(){});
    }

    public DashboardList updateDashboardList(Long listId, DashboardList body) throws ApiException {
        return this.updateDashboardListWithHttpInfo(listId, body).getData();
    }

    public CompletableFuture<DashboardList> updateDashboardListAsync(Long listId, DashboardList body) {
        return this.updateDashboardListWithHttpInfoAsync(listId, body).thenApply(response -> (DashboardList)response.getData());
    }

    public ApiResponse<DashboardList> updateDashboardListWithHttpInfo(Long listId, DashboardList body) throws ApiException {
        DashboardList localVarPostBody = body;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling updateDashboardList");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardListsApi.updateDashboardList", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardList>(){});
    }

    public CompletableFuture<ApiResponse<DashboardList>> updateDashboardListWithHttpInfoAsync(Long listId, DashboardList body) {
        Invocation.Builder builder;
        DashboardList localVarPostBody = body;
        if (listId == null) {
            CompletableFuture<ApiResponse<DashboardList>> result = new CompletableFuture<ApiResponse<DashboardList>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'listId' when calling updateDashboardList"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<DashboardList>> result = new CompletableFuture<ApiResponse<DashboardList>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDashboardList"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("DashboardListsApi.updateDashboardList", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardList>> result = new CompletableFuture<ApiResponse<DashboardList>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardList>(){});
    }
}

