/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.DistributionWidgetDefinitionType;
import com.datadog.api.client.v1.model.DistributionWidgetRequest;
import com.datadog.api.client.v1.model.DistributionWidgetXAxis;
import com.datadog.api.client.v1.model.DistributionWidgetYAxis;
import com.datadog.api.client.v1.model.WidgetMarker;
import com.datadog.api.client.v1.model.WidgetTextAlign;
import com.datadog.api.client.v1.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"legend_size", "markers", "requests", "show_legend", "time", "title", "title_align", "title_size", "type", "xaxis", "yaxis"})
public class DistributionWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_LEGEND_SIZE = "legend_size";
    private String legendSize;
    public static final String JSON_PROPERTY_MARKERS = "markers";
    private List<WidgetMarker> markers = null;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<DistributionWidgetRequest> requests = new ArrayList<DistributionWidgetRequest>();
    public static final String JSON_PROPERTY_SHOW_LEGEND = "show_legend";
    private Boolean showLegend;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private DistributionWidgetDefinitionType type = DistributionWidgetDefinitionType.DISTRIBUTION;
    public static final String JSON_PROPERTY_XAXIS = "xaxis";
    private DistributionWidgetXAxis xaxis;
    public static final String JSON_PROPERTY_YAXIS = "yaxis";
    private DistributionWidgetYAxis yaxis;

    public DistributionWidgetDefinition() {
    }

    @JsonCreator
    public DistributionWidgetDefinition(@JsonProperty(required=true, value="requests") List<DistributionWidgetRequest> requests, @JsonProperty(required=true, value="type") DistributionWidgetDefinitionType type) {
        this.requests = requests;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public DistributionWidgetDefinition legendSize(String legendSize) {
        this.legendSize = legendSize;
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="legend_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegendSize() {
        return this.legendSize;
    }

    @Deprecated
    public void setLegendSize(String legendSize) {
        this.legendSize = legendSize;
    }

    public DistributionWidgetDefinition markers(List<WidgetMarker> markers) {
        this.markers = markers;
        for (WidgetMarker item : markers) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public DistributionWidgetDefinition addMarkersItem(WidgetMarker markersItem) {
        if (this.markers == null) {
            this.markers = new ArrayList<WidgetMarker>();
        }
        this.markers.add(markersItem);
        this.unparsed |= markersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="markers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetMarker> getMarkers() {
        return this.markers;
    }

    public void setMarkers(List<WidgetMarker> markers) {
        this.markers = markers;
    }

    public DistributionWidgetDefinition requests(List<DistributionWidgetRequest> requests) {
        this.requests = requests;
        for (DistributionWidgetRequest item : requests) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public DistributionWidgetDefinition addRequestsItem(DistributionWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        this.unparsed |= requestsItem.unparsed;
        return this;
    }

    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<DistributionWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<DistributionWidgetRequest> requests) {
        this.requests = requests;
    }

    public DistributionWidgetDefinition showLegend(Boolean showLegend) {
        this.showLegend = showLegend;
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="show_legend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowLegend() {
        return this.showLegend;
    }

    @Deprecated
    public void setShowLegend(Boolean showLegend) {
        this.showLegend = showLegend;
    }

    public DistributionWidgetDefinition time(WidgetTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public DistributionWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DistributionWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public DistributionWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public DistributionWidgetDefinition type(DistributionWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DistributionWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(DistributionWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public DistributionWidgetDefinition xaxis(DistributionWidgetXAxis xaxis) {
        this.xaxis = xaxis;
        this.unparsed |= xaxis.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="xaxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DistributionWidgetXAxis getXaxis() {
        return this.xaxis;
    }

    public void setXaxis(DistributionWidgetXAxis xaxis) {
        this.xaxis = xaxis;
    }

    public DistributionWidgetDefinition yaxis(DistributionWidgetYAxis yaxis) {
        this.yaxis = yaxis;
        this.unparsed |= yaxis.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="yaxis")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DistributionWidgetYAxis getYaxis() {
        return this.yaxis;
    }

    public void setYaxis(DistributionWidgetYAxis yaxis) {
        this.yaxis = yaxis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionWidgetDefinition distributionWidgetDefinition = (DistributionWidgetDefinition)o;
        return Objects.equals(this.legendSize, distributionWidgetDefinition.legendSize) && Objects.equals(this.markers, distributionWidgetDefinition.markers) && Objects.equals(this.requests, distributionWidgetDefinition.requests) && Objects.equals(this.showLegend, distributionWidgetDefinition.showLegend) && Objects.equals(this.time, distributionWidgetDefinition.time) && Objects.equals(this.title, distributionWidgetDefinition.title) && Objects.equals(this.titleAlign, distributionWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, distributionWidgetDefinition.titleSize) && Objects.equals(this.type, distributionWidgetDefinition.type) && Objects.equals(this.xaxis, distributionWidgetDefinition.xaxis) && Objects.equals(this.yaxis, distributionWidgetDefinition.yaxis);
    }

    public int hashCode() {
        return Objects.hash(this.legendSize, this.markers, this.requests, this.showLegend, this.time, this.title, this.titleAlign, this.titleSize, this.type, this.xaxis, this.yaxis);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DistributionWidgetDefinition {\n");
        sb.append("    legendSize: ").append(this.toIndentedString(this.legendSize)).append("\n");
        sb.append("    markers: ").append(this.toIndentedString(this.markers)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    showLegend: ").append(this.toIndentedString(this.showLegend)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    xaxis: ").append(this.toIndentedString(this.xaxis)).append("\n");
        sb.append("    yaxis: ").append(this.toIndentedString(this.yaxis)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

