/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=EventAlertTypeSerializer.class)
public class EventAlertType {
    public static final EventAlertType ERROR = new EventAlertType("error");
    public static final EventAlertType WARNING = new EventAlertType("warning");
    public static final EventAlertType INFO = new EventAlertType("info");
    public static final EventAlertType SUCCESS = new EventAlertType("success");
    public static final EventAlertType USER_UPDATE = new EventAlertType("user_update");
    public static final EventAlertType RECOMMENDATION = new EventAlertType("recommendation");
    public static final EventAlertType SNAPSHOT = new EventAlertType("snapshot");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("error", "warning", "info", "success", "user_update", "recommendation", "snapshot"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    EventAlertType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((EventAlertType)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static EventAlertType fromValue(String value) {
        return new EventAlertType(value);
    }

    public static class EventAlertTypeSerializer
    extends StdSerializer<EventAlertType> {
        public EventAlertTypeSerializer(Class<EventAlertType> t) {
            super(t);
        }

        public EventAlertTypeSerializer() {
            this(null);
        }

        public void serialize(EventAlertType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

