/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.Log;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"logs", "nextLogId", "status"})
public class LogsListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_LOGS = "logs";
    private List<Log> logs = null;
    public static final String JSON_PROPERTY_NEXT_LOG_ID = "nextLogId";
    private String nextLogId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;

    public LogsListResponse logs(List<Log> logs) {
        this.logs = logs;
        for (Log item : logs) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsListResponse addLogsItem(Log logsItem) {
        if (this.logs == null) {
            this.logs = new ArrayList<Log>();
        }
        this.logs.add(logsItem);
        this.unparsed |= logsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="logs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Log> getLogs() {
        return this.logs;
    }

    public void setLogs(List<Log> logs) {
        this.logs = logs;
    }

    public LogsListResponse nextLogId(String nextLogId) {
        this.nextLogId = nextLogId;
        return this;
    }

    @Nullable
    @JsonProperty(value="nextLogId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNextLogId() {
        return this.nextLogId;
    }

    public void setNextLogId(String nextLogId) {
        this.nextLogId = nextLogId;
    }

    public LogsListResponse status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsListResponse logsListResponse = (LogsListResponse)o;
        return Objects.equals(this.logs, logsListResponse.logs) && Objects.equals(this.nextLogId, logsListResponse.nextLogId) && Objects.equals(this.status, logsListResponse.status);
    }

    public int hashCode() {
        return Objects.hash(this.logs, this.nextLogId, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsListResponse {\n");
        sb.append("    logs: ").append(this.toIndentedString(this.logs)).append("\n");
        sb.append("    nextLogId: ").append(this.toIndentedString(this.nextLogId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

