/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client;

import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.JSON;
import com.datadog.api.client.Pair;
import com.datadog.api.client.RFC3339DateFormat;
import com.datadog.api.client.ServerConfiguration;
import com.datadog.api.client.ServerVariable;
import com.datadog.api.client.StringUtil;
import com.datadog.api.client.ZstdEncoder;
import com.datadog.api.client.auth.ApiKeyAuth;
import com.datadog.api.client.auth.Authentication;
import com.datadog.api.client.auth.HttpBasicAuth;
import com.datadog.api.client.auth.HttpBearerAuth;
import com.datadog.api.client.auth.OAuth;
import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.filter.EncodingFilter;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.DeflateEncoder;
import org.glassfish.jersey.message.GZipEncoder;

public class ApiClient {
    protected Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    protected Map<String, String> defaultCookieMap = new HashMap<String, String>();
    protected String basePath = "https://api.datadoghq.com";
    protected String userAgent;
    private DateTimeFormatter offsetDateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    protected List<ServerConfiguration> servers = new ArrayList<ServerConfiguration>(Arrays.asList(new ServerConfiguration("https://{subdomain}.{site}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
        {
            this.put("site", new ServerVariable("The regional site for Datadog customers.", "datadoghq.com", new HashSet<String>(Arrays.asList("datadoghq.com", "us3.datadoghq.com", "us5.datadoghq.com", "datadoghq.eu", "ddog-gov.com"))));
            this.put("subdomain", new ServerVariable("The subdomain where the API is deployed.", "api", new HashSet<String>()));
        }
    }), new ServerConfiguration("{protocol}://{name}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
        {
            this.put("name", new ServerVariable("Full site DNS name.", "api.datadoghq.com", new HashSet<String>()));
            this.put("protocol", new ServerVariable("The protocol for accessing the API.", "https", new HashSet<String>()));
        }
    }), new ServerConfiguration("https://{subdomain}.{site}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
        {
            this.put("site", new ServerVariable("Any Datadog deployment.", "datadoghq.com", new HashSet<String>()));
            this.put("subdomain", new ServerVariable("The subdomain where the API is deployed.", "api", new HashSet<String>()));
        }
    })));
    protected Integer serverIndex = 0;
    protected Map<String, String> serverVariables = null;
    protected Map<String, List<ServerConfiguration>> operationServers = new HashMap<String, List<ServerConfiguration>>(){
        {
            this.put("v1.IpRangesApi.getIPRanges", new ArrayList<ServerConfiguration>(Arrays.asList(new ServerConfiguration("https://{subdomain}.{site}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("site", new ServerVariable("The regional site for Datadog customers.", "datadoghq.com", new HashSet<String>(Arrays.asList("datadoghq.com", "us3.datadoghq.com", "us5.datadoghq.com", "datadoghq.eu", "ddog-gov.com"))));
                    this.put("subdomain", new ServerVariable("The subdomain where the API is deployed.", "ip-ranges", new HashSet<String>()));
                }
            }), new ServerConfiguration("{protocol}://{name}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("name", new ServerVariable("Full site DNS name.", "ip-ranges.datadoghq.com", new HashSet<String>()));
                    this.put("protocol", new ServerVariable("The protocol for accessing the API.", "https", new HashSet<String>()));
                }
            }), new ServerConfiguration("https://{subdomain}.datadoghq.com", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("subdomain", new ServerVariable("The subdomain where the API is deployed.", "ip-ranges", new HashSet<String>()));
                }
            }))));
            this.put("v1.ServiceLevelObjectivesApi.searchSLO", new ArrayList<ServerConfiguration>(Arrays.asList(new ServerConfiguration("https://{subdomain}.{site}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("site", new ServerVariable("The regional site for Datadog customers.", "datadoghq.com", new HashSet<String>(Arrays.asList("datadoghq.com", "datadoghq.eu", "us3.datadoghq.com", "us5.datadoghq.com", "ddog-gov.com"))));
                    this.put("subdomain", new ServerVariable("The subdomain where the API is deployed.", "api", new HashSet<String>()));
                }
            }), new ServerConfiguration("{protocol}://{name}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("name", new ServerVariable("Full site DNS name.", "api.datadoghq.com", new HashSet<String>()));
                    this.put("protocol", new ServerVariable("The protocol for accessing the API.", "https", new HashSet<String>()));
                }
            }), new ServerConfiguration("https://{subdomain}.{site}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("site", new ServerVariable("Any Datadog deployment.", "datadoghq.com", new HashSet<String>()));
                    this.put("subdomain", new ServerVariable("The subdomain where the API is deployed.", "api", new HashSet<String>()));
                }
            }))));
            this.put("v1.LogsApi.submitLog", new ArrayList<ServerConfiguration>(Arrays.asList(new ServerConfiguration("https://{subdomain}.{site}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("site", new ServerVariable("The regional site for Datadog customers.", "datadoghq.com", new HashSet<String>(Arrays.asList("datadoghq.com", "us3.datadoghq.com", "us5.datadoghq.com", "datadoghq.eu", "ddog-gov.com"))));
                    this.put("subdomain", new ServerVariable("The subdomain where the API is deployed.", "http-intake.logs", new HashSet<String>()));
                }
            }), new ServerConfiguration("{protocol}://{name}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("name", new ServerVariable("Full site DNS name.", "http-intake.logs.datadoghq.com", new HashSet<String>()));
                    this.put("protocol", new ServerVariable("The protocol for accessing the API.", "https", new HashSet<String>()));
                }
            }), new ServerConfiguration("https://{subdomain}.{site}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("site", new ServerVariable("Any Datadog deployment.", "datadoghq.com", new HashSet<String>()));
                    this.put("subdomain", new ServerVariable("The subdomain where the API is deployed.", "http-intake.logs", new HashSet<String>()));
                }
            }))));
            this.put("v2.LogsApi.submitLog", new ArrayList<ServerConfiguration>(Arrays.asList(new ServerConfiguration("https://{subdomain}.{site}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("site", new ServerVariable("The regional site for customers.", "datadoghq.com", new HashSet<String>(Arrays.asList("datadoghq.com", "us3.datadoghq.com", "us5.datadoghq.com", "datadoghq.eu", "ddog-gov.com"))));
                    this.put("subdomain", new ServerVariable("The subdomain where the API is deployed.", "http-intake.logs", new HashSet<String>()));
                }
            }), new ServerConfiguration("{protocol}://{name}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("name", new ServerVariable("Full site DNS name.", "http-intake.logs.datadoghq.com", new HashSet<String>()));
                    this.put("protocol", new ServerVariable("The protocol for accessing the API.", "https", new HashSet<String>()));
                }
            }), new ServerConfiguration("https://{subdomain}.{site}", "No description provided", (Map<String, ServerVariable>)new HashMap<String, ServerVariable>(){
                {
                    this.put("site", new ServerVariable("Any Datadog deployment.", "datadoghq.com", new HashSet<String>()));
                    this.put("subdomain", new ServerVariable("The subdomain where the API is deployed.", "http-intake.logs", new HashSet<String>()));
                }
            }))));
        }
    };
    protected Map<String, Integer> operationServerIndex = new HashMap<String, Integer>();
    protected Map<String, Map<String, String>> operationServerVariables = new HashMap<String, Map<String, String>>();
    protected boolean debugging = false;
    protected boolean compress = true;
    protected ClientConfig clientConfig;
    protected int connectionTimeout = 0;
    private int readTimeout = 0;
    protected Client httpClient;
    protected JSON json;
    protected String tempFolderPath = null;
    protected Map<String, Authentication> authentications;
    protected DateFormat dateFormat;
    protected final Map<String, Boolean> unstableOperations = new HashMap<String, Boolean>(){
        {
            this.put("v2.listEvents", false);
            this.put("v2.searchEvents", false);
            this.put("v2.createIncident", false);
            this.put("v2.deleteIncident", false);
            this.put("v2.getIncident", false);
            this.put("v2.listIncidentAttachments", false);
            this.put("v2.listIncidents", false);
            this.put("v2.searchIncidents", false);
            this.put("v2.updateIncident", false);
            this.put("v2.updateIncidentAttachments", false);
            this.put("v2.queryScalarData", false);
            this.put("v2.queryTimeseriesData", false);
            this.put("v2.createIncidentService", false);
            this.put("v2.deleteIncidentService", false);
            this.put("v2.getIncidentService", false);
            this.put("v2.listIncidentServices", false);
            this.put("v2.updateIncidentService", false);
            this.put("v2.createIncidentTeam", false);
            this.put("v2.deleteIncidentTeam", false);
            this.put("v2.getIncidentTeam", false);
            this.put("v2.listIncidentTeams", false);
            this.put("v2.updateIncidentTeam", false);
        }
    };
    protected static final Logger logger = Logger.getLogger(ApiClient.class.getName());
    private static ApiClient defaultApiClient;

    public static ApiClient getDefaultApiClient() {
        String appKeyAuth;
        if (defaultApiClient != null) {
            return defaultApiClient;
        }
        defaultApiClient = new ApiClient();
        String site = System.getenv("DD_SITE");
        if (site != null) {
            HashMap<String, String> serverVariables = new HashMap<String, String>();
            serverVariables.put("site", site);
            defaultApiClient.setServerVariables(serverVariables);
        }
        HashMap<String, String> secrets = new HashMap<String, String>();
        String apiKeyAuth = System.getenv("DD_API_KEY");
        if (apiKeyAuth != null) {
            secrets.put("apiKeyAuth", apiKeyAuth);
        }
        if ((appKeyAuth = System.getenv("DD_APP_KEY")) != null) {
            secrets.put("appKeyAuth", appKeyAuth);
        }
        defaultApiClient.configureApiKeys(secrets);
        return defaultApiClient;
    }

    public static void setDefaultApiClient(ApiClient apiClient) {
        defaultApiClient = apiClient;
    }

    public ApiClient() {
        this(null);
    }

    public ApiClient(Map<String, Authentication> authMap) {
        this.json = new JSON();
        this.httpClient = this.buildHttpClient();
        this.dateFormat = new RFC3339DateFormat();
        this.setUserAgent();
        this.authentications = new HashMap<String, Authentication>();
        Authentication auth = null;
        if (authMap != null) {
            auth = authMap.get("AuthZ");
        }
        if (auth instanceof OAuth) {
            this.authentications.put("AuthZ", auth);
        } else {
            this.authentications.put("AuthZ", new OAuth(this.basePath, "/oauth2/v1/token"));
        }
        if (authMap != null) {
            auth = authMap.get("apiKeyAuth");
        }
        if (auth instanceof ApiKeyAuth) {
            this.authentications.put("apiKeyAuth", auth);
        } else {
            this.authentications.put("apiKeyAuth", new ApiKeyAuth("header", "DD-API-KEY"));
        }
        if (authMap != null) {
            auth = authMap.get("appKeyAuth");
        }
        if (auth instanceof ApiKeyAuth) {
            this.authentications.put("appKeyAuth", auth);
        } else {
            this.authentications.put("appKeyAuth", new ApiKeyAuth("header", "DD-APPLICATION-KEY"));
        }
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public DateTimeFormatter getOffsetDateTimeFormatter() {
        return this.offsetDateTimeFormatter;
    }

    public void setOffsetDateTimeFormatter(DateTimeFormatter offsetDateTimeFormatter) {
        this.offsetDateTimeFormatter = offsetDateTimeFormatter;
    }

    public String formatOffsetDateTime(OffsetDateTime offsetDateTime) {
        return this.offsetDateTimeFormatter.format(offsetDateTime);
    }

    public JSON getJSON() {
        return this.json;
    }

    public Client getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(Client httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        this.setOauthBasePath(basePath);
        return this;
    }

    public List<ServerConfiguration> getServers() {
        return this.servers;
    }

    public ApiClient setServers(List<ServerConfiguration> servers) {
        this.servers = servers;
        this.updateBasePath();
        return this;
    }

    public Integer getServerIndex() {
        return this.serverIndex;
    }

    public ApiClient setServerIndex(Integer serverIndex) {
        this.serverIndex = serverIndex;
        this.updateBasePath();
        return this;
    }

    public Map<String, String> getServerVariables() {
        return this.serverVariables;
    }

    public ApiClient setServerVariables(Map<String, String> serverVariables) {
        this.serverVariables = serverVariables;
        this.updateBasePath();
        return this;
    }

    private void updateBasePath() {
        if (this.serverIndex != null) {
            this.setBasePath(this.servers.get(this.serverIndex).URL(this.serverVariables));
        }
    }

    private void setOauthBasePath(String basePath) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setBasePath(basePath);
        }
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public ApiClient setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return this;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public ApiClient setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return this;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public ApiClient setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return this;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public ApiClient configureApiKeys(Map<String, String> secrets) {
        for (Map.Entry<String, Authentication> authEntry : this.authentications.entrySet()) {
            String name;
            Authentication auth = authEntry.getValue();
            if (!(auth instanceof ApiKeyAuth) || !secrets.containsKey(name = authEntry.getKey())) continue;
            ((ApiKeyAuth)auth).setApiKey(secrets.get(name));
        }
        return this;
    }

    public ApiClient setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return this;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public ApiClient setBearerToken(String bearerToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBearerAuth)) continue;
            ((HttpBearerAuth)auth).setBearerToken(bearerToken);
            return this;
        }
        throw new RuntimeException("No Bearer authentication configured!");
    }

    public ApiClient setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setOauthCredentials(String clientId, String clientSecret) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setCredentials(clientId, clientSecret, this.isDebugging());
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setOauthPasswordFlow(String username, String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).usePasswordFlow(username, password);
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setOauthAuthorizationCodeFlow(String code) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).useAuthorizationCodeFlow(code);
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setOauthScope(String scope) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setScope(scope);
            return this;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public ApiClient setUserAgent() {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getClassLoader().getResourceAsStream("com/datadog/api/project.properties"));
        }
        catch (IOException e) {
            logger.severe("Could not load client version: " + e.toString());
        }
        String userAgent = "datadog-api-client-java/" + properties.getProperty("version") + " (java " + System.getProperty("java.version") + "; java_vendor " + System.getProperty("java.vendor") + "; os " + System.getProperty("os.name") + "; os_version " + System.getProperty("os.version") + "; arch " + System.getProperty("os.arch") + ")";
        this.addDefaultHeader("User-Agent", userAgent);
        this.userAgent = userAgent;
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public ApiClient addDefaultCookie(String key, String value) {
        this.defaultCookieMap.put(key, value);
        return this;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public ApiClient setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.httpClient = this.buildHttpClient();
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        this.setClientConfig(null);
        return this;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public ApiClient setCompress(boolean compress) {
        this.compress = compress;
        this.setClientConfig(null);
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectionTimeout;
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.httpClient.property("jersey.config.client.connectTimeout", (Object)connectionTimeout);
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        this.httpClient.property("jersey.config.client.readTimeout", (Object)readTimeout);
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.json.setDateFormat((DateFormat)dateFormat.clone());
        return this;
    }

    public Set<String> getUnstableOperations() {
        return this.unstableOperations.keySet();
    }

    public boolean setUnstableOperationEnabled(String operation, boolean enabled) {
        if (this.unstableOperations.containsKey(operation)) {
            this.unstableOperations.put(operation, enabled);
            return true;
        }
        logger.warning(String.format("'%s' is not an unstable operation, can't enable/disable", operation));
        return false;
    }

    public boolean isUnstableOperation(String operation) {
        return this.unstableOperations.containsKey(operation);
    }

    public boolean isUnstableOperationEnabled(String operation) {
        if (this.unstableOperations.containsKey(operation)) {
            return this.unstableOperations.get(operation);
        }
        logger.warning(String.format("'%s' is not an unstable operation, is always enabled", operation));
        return true;
    }

    public Logger getLogger() {
        return logger;
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof OffsetDateTime) {
            return this.formatOffsetDateTime((OffsetDateTime)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        String format;
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        Collection valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = format = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if ("multi".equals(format)) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if ("csv".equals(format)) {
            delimiter = ",";
        } else if ("ssv".equals(format)) {
            delimiter = " ";
        } else if ("tsv".equals(format)) {
            delimiter = "\t";
        } else if ("pipes".equals(format)) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public Entity<?> serialize(Object obj, Map<String, Object> formParams, String contentType, String contentEncoding, boolean isBodyNullable) {
        Entity entity;
        Variant variant = new Variant(MediaType.valueOf((String)contentType), "", contentEncoding);
        if (contentType.startsWith("multipart/form-data")) {
            MultiPart multiPart = new MultiPart();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                if (param.getValue() instanceof File) {
                    File file = (File)param.getValue();
                    FormDataContentDisposition contentDisp = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)param.getKey()).fileName(file.getName())).size(file.length())).build();
                    multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
                    continue;
                }
                FormDataContentDisposition contentDisp = FormDataContentDisposition.name((String)param.getKey()).build();
                multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, this.parameterToString(param.getValue())));
            }
            entity = Entity.entity((Object)multiPart, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE);
        } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
            Form form = new Form();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                form.param(param.getKey(), this.parameterToString(param.getValue()));
            }
            entity = Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else {
            entity = isBodyNullable ? (obj instanceof String ? Entity.entity((Object)(obj == null ? "null" : "\"" + ((String)obj).replaceAll("\"", Matcher.quoteReplacement("\\\"")) + "\""), (Variant)variant) : Entity.entity((Object)(obj == null ? "null" : obj), (Variant)variant)) : (obj instanceof String ? Entity.entity((Object)(obj == null ? "" : "\"" + ((String)obj).replaceAll("\"", Matcher.quoteReplacement("\\\"")) + "\""), (Variant)variant) : Entity.entity((Object)(obj == null ? "" : obj), (Variant)variant));
        }
        return entity;
    }

    public <T> T deserialize(Response response, GenericType<T> returnType) {
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            return (T)response.readEntity(byte[].class);
        }
        String contentType = null;
        List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty()) {
            contentType = String.valueOf(contentTypes.get(0));
        }
        response.bufferEntity();
        return (T)response.readEntity(returnType);
    }

    public Invocation.Builder createBuilder(String operation, String path, List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, String[] accepts, String[] authNames) throws ApiException {
        String value;
        URI parsedURI;
        String targetURL;
        if (this.serverIndex != null && this.operationServers.containsKey(operation)) {
            Integer index = this.operationServerIndex.containsKey(operation) ? this.operationServerIndex.get(operation) : this.serverIndex;
            Map<String, String> variables = this.operationServerVariables.containsKey(operation) ? this.operationServerVariables.get(operation) : this.serverVariables;
            List<ServerConfiguration> serverConfigurations = this.operationServers.get(operation);
            if (index < 0 || index >= serverConfigurations.size()) {
                throw new ArrayIndexOutOfBoundsException(String.format("Invalid index %d when selecting the host settings. Must be less than %d", index, serverConfigurations.size()));
            }
            targetURL = ((ServerConfiguration)serverConfigurations.get(index)).URL(variables) + path;
        } else {
            targetURL = this.basePath + path;
        }
        try {
            parsedURI = new URI(targetURL);
        }
        catch (URISyntaxException e) {
            throw new ApiException(e);
        }
        WebTarget target = this.httpClient.target(parsedURI);
        for (Pair pair : queryParams) {
            if (pair.getValue() == null) continue;
            target = target.queryParam(pair.getName(), new Object[]{this.escapeString(pair.getValue())});
        }
        Invocation.Builder invocationBuilder = target.request().accept(new String[]{this.selectHeaderAccept(accepts)});
        for (Map.Entry<String, String> entry : cookieParams.entrySet()) {
            value = entry.getValue();
            if (value == null) continue;
            invocationBuilder = invocationBuilder.cookie(entry.getKey(), value);
        }
        for (Map.Entry<String, String> entry : this.defaultCookieMap.entrySet()) {
            value = entry.getValue();
            if (value == null) continue;
            invocationBuilder = invocationBuilder.cookie(entry.getKey(), value);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(this.defaultHeaderMap);
        hashMap.putAll(headerParams);
        this.updateParamsForAuth(authNames, queryParams, hashMap, cookieParams, target.getUri());
        for (Map.Entry entry : hashMap.entrySet()) {
            String value2 = (String)entry.getValue();
            if (value2 == null) continue;
            invocationBuilder = invocationBuilder.header((String)entry.getKey(), (Object)value2);
        }
        return invocationBuilder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> ApiResponse<T> invokeAPI(String method, Invocation.Builder invocationBuilder, Map<String, String> headerParams, String[] contentTypes, Object body, Map<String, Object> formParams, Boolean isBodyNullable, GenericType<T> returnType) throws ApiException {
        String contentEncoding = headerParams.get("Content-Encoding");
        Entity<?> entity = this.serialize(body, formParams, this.selectHeaderContentType(contentTypes), contentEncoding, isBodyNullable);
        Response response = null;
        try {
            response = this.sendRequest(method, invocationBuilder, entity);
            int statusCode = response.getStatusInfo().getStatusCode();
            Map<String, List<String>> responseHeaders = this.buildResponseHeaders(response);
            if (response.getStatusInfo() == Response.Status.NO_CONTENT) {
                ApiResponse apiResponse = new ApiResponse(statusCode, responseHeaders);
                return apiResponse;
            }
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                if (returnType == null) {
                    ApiResponse apiResponse = new ApiResponse(statusCode, responseHeaders);
                    return apiResponse;
                }
                ApiResponse<T> apiResponse = new ApiResponse<T>(statusCode, responseHeaders, this.deserialize(response, returnType));
                return apiResponse;
            }
            String message = "error";
            String respBody = null;
            if (!response.hasEntity()) throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
            try {
                message = respBody = String.valueOf(response.readEntity(String.class));
                throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
        }
        finally {
            try {
                response.close();
            }
            catch (Exception exception) {}
        }
    }

    private Response sendRequest(String method, Invocation.Builder invocationBuilder, Entity<?> entity) {
        Response response = "POST".equals(method) ? invocationBuilder.post(entity) : ("PUT".equals(method) ? invocationBuilder.put(entity) : ("DELETE".equals(method) ? invocationBuilder.method("DELETE", entity) : ("PATCH".equals(method) ? invocationBuilder.method("PATCH", entity) : invocationBuilder.method(method))));
        return response;
    }

    public <T> CompletableFuture<ApiResponse<T>> invokeAPIAsync(String method, Invocation.Builder invocationBuilder, Map<String, String> headerParams, String[] contentTypes, Object body, Map<String, Object> formParams, Boolean isBodyNullable, final GenericType<T> returnType) {
        String contentEncoding = headerParams.get("Content-Encoding");
        Entity<?> entity = this.serialize(body, formParams, this.selectHeaderContentType(contentTypes), contentEncoding, isBodyNullable);
        final CompletableFuture<ApiResponse<T>> result = new CompletableFuture<ApiResponse<T>>();
        InvocationCallback<Response> callback = new InvocationCallback<Response>(){

            public void completed(Response response) {
                int statusCode = response.getStatusInfo().getStatusCode();
                Map<String, List<String>> responseHeaders = ApiClient.this.buildResponseHeaders(response);
                if (response.getStatusInfo() == Response.Status.NO_CONTENT) {
                    result.complete(new ApiResponse(statusCode, responseHeaders));
                } else if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    if (returnType == null) {
                        result.complete(new ApiResponse(statusCode, responseHeaders));
                    } else {
                        result.complete(new ApiResponse(statusCode, responseHeaders, ApiClient.this.deserialize(response, returnType)));
                    }
                } else {
                    String message = "error";
                    String respBody = null;
                    if (response.hasEntity()) {
                        try {
                            message = respBody = String.valueOf(response.readEntity(String.class));
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                    result.completeExceptionally(new ApiException(response.getStatus(), message, ApiClient.this.buildResponseHeaders(response), respBody));
                }
            }

            public void failed(Throwable throwable) {
                result.completeExceptionally(throwable);
            }
        };
        this.sendRequestAsync(method, invocationBuilder, entity, callback);
        return result;
    }

    private Future<Response> sendRequestAsync(String method, Invocation.Builder invocationBuilder, Entity<?> entity, InvocationCallback<Response> callback) {
        AsyncInvoker invoker = invocationBuilder.async();
        Future response = "POST".equals(method) ? invoker.post(entity, callback) : ("PUT".equals(method) ? invoker.put(entity, callback) : ("DELETE".equals(method) ? invoker.method("DELETE", entity, callback) : ("PATCH".equals(method) ? invoker.method("PATCH", entity, callback) : invoker.method(method, callback))));
        return response;
    }

    protected Client buildHttpClient() {
        if (this.clientConfig == null) {
            this.clientConfig = this.getDefaultClientConfig();
        }
        if (this.compress) {
            this.clientConfig.register(EncodingFilter.class);
        }
        this.clientConfig.register(GZipEncoder.class);
        this.clientConfig.register(DeflateEncoder.class);
        this.clientConfig.register(ZstdEncoder.class);
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        this.customizeClientBuilder(clientBuilder);
        clientBuilder = clientBuilder.withConfig((Configuration)this.clientConfig);
        return clientBuilder.build();
    }

    public ClientConfig getDefaultClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(MultiPartFeature.class);
        clientConfig.register((Object)this.json);
        clientConfig.register(JacksonFeature.class);
        clientConfig.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        clientConfig.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        if (this.debugging) {
            clientConfig.register((Object)new LoggingFeature(Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(51200)));
            clientConfig.property("jersey.config.logging.verbosity", (Object)LoggingFeature.Verbosity.PAYLOAD_ANY);
            Logger.getLogger(LoggingFeature.DEFAULT_LOGGER_NAME).setLevel(Level.ALL);
        } else {
            Logger.getLogger("org.glassfish.jersey.client").setLevel(Level.SEVERE);
        }
        return clientConfig;
    }

    protected void customizeClientBuilder(ClientBuilder clientBuilder) {
    }

    protected void disableCertificateValidation(ClientBuilder clientBuilder) throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new X509TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        clientBuilder.sslContext(sslContext);
    }

    protected Map<String, List<String>> buildResponseHeaders(Response response) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            List values = (List)entry.getValue();
            ArrayList<String> headers = new ArrayList<String>();
            for (Object o : values) {
                headers.add(String.valueOf(o));
            }
            responseHeaders.put((String)entry.getKey(), (List<String>)headers);
        }
        return responseHeaders;
    }

    protected void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, URI uri) throws ApiException {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) continue;
            auth.applyToParams(queryParams, headerParams, cookieParams, "", "", uri);
        }
    }
}

