/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.RunWorkflowWidgetDefinitionType;
import com.datadog.api.client.v1.model.RunWorkflowWidgetInput;
import com.datadog.api.client.v1.model.WidgetCustomLink;
import com.datadog.api.client.v1.model.WidgetTextAlign;
import com.datadog.api.client.v1.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"custom_links", "inputs", "time", "title", "title_align", "title_size", "type", "workflow_id"})
public class RunWorkflowWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_INPUTS = "inputs";
    private List<RunWorkflowWidgetInput> inputs = null;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private RunWorkflowWidgetDefinitionType type = RunWorkflowWidgetDefinitionType.RUN_WORKFLOW;
    public static final String JSON_PROPERTY_WORKFLOW_ID = "workflow_id";
    private String workflowId;

    public RunWorkflowWidgetDefinition() {
    }

    @JsonCreator
    public RunWorkflowWidgetDefinition(@JsonProperty(required=true, value="type") RunWorkflowWidgetDefinitionType type, @JsonProperty(required=true, value="workflow_id") String workflowId) {
        this.type = type;
        this.unparsed |= !type.isValid();
        this.workflowId = workflowId;
    }

    public RunWorkflowWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        for (WidgetCustomLink item : customLinks) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public RunWorkflowWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        this.unparsed |= customLinksItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public RunWorkflowWidgetDefinition inputs(List<RunWorkflowWidgetInput> inputs) {
        this.inputs = inputs;
        for (RunWorkflowWidgetInput item : inputs) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public RunWorkflowWidgetDefinition addInputsItem(RunWorkflowWidgetInput inputsItem) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<RunWorkflowWidgetInput>();
        }
        this.inputs.add(inputsItem);
        this.unparsed |= inputsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="inputs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RunWorkflowWidgetInput> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<RunWorkflowWidgetInput> inputs) {
        this.inputs = inputs;
    }

    public RunWorkflowWidgetDefinition time(WidgetTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public RunWorkflowWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public RunWorkflowWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public RunWorkflowWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public RunWorkflowWidgetDefinition type(RunWorkflowWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RunWorkflowWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(RunWorkflowWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public RunWorkflowWidgetDefinition workflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    @JsonProperty(value="workflow_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunWorkflowWidgetDefinition runWorkflowWidgetDefinition = (RunWorkflowWidgetDefinition)o;
        return Objects.equals(this.customLinks, runWorkflowWidgetDefinition.customLinks) && Objects.equals(this.inputs, runWorkflowWidgetDefinition.inputs) && Objects.equals(this.time, runWorkflowWidgetDefinition.time) && Objects.equals(this.title, runWorkflowWidgetDefinition.title) && Objects.equals(this.titleAlign, runWorkflowWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, runWorkflowWidgetDefinition.titleSize) && Objects.equals(this.type, runWorkflowWidgetDefinition.type) && Objects.equals(this.workflowId, runWorkflowWidgetDefinition.workflowId);
    }

    public int hashCode() {
        return Objects.hash(this.customLinks, this.inputs, this.time, this.title, this.titleAlign, this.titleSize, this.type, this.workflowId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RunWorkflowWidgetDefinition {\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    workflowId: ").append(this.toIndentedString(this.workflowId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

