/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Revision;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service
@Property(name="process.label", value={"Create Version"})
public class CreateVersionProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(CreateVersionProcess.class);
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    public static final String TYPE_JCR_UUID = "JCR_UUID";
    @Reference
    private JcrResourceResolverFactory jcrResolverFactory = null;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        try {
            Session session = workflowSession.getSession();
            WorkflowData data = workItem.getWorkflowData();
            String path = null;
            String type = data.getPayloadType();
            if (type.equals(TYPE_JCR_PATH) && data.getPayload() != null) {
                String payloadData = (String)data.getPayload();
                if (session.itemExists(payloadData)) {
                    path = payloadData;
                }
            } else if (data.getPayload() != null && type.equals(TYPE_JCR_UUID)) {
                Node node = session.getNodeByIdentifier((String)data.getPayload());
                path = node.getPath();
            }
            if (path != null) {
                Resource res = this.jcrResolverFactory.getResourceResolver(session).getResource(path);
                String revStr = null;
                if (res.adaptTo(Page.class) != null) {
                    Page page = (Page)res.adaptTo(Page.class);
                    PageManager pm = page.getPageManager();
                    String versionLabel = this.createUniqueVersionLabel(pm.getRevisions(page.getPath(), null), this.getAbsTime(workItem));
                    com.day.cq.wcm.api.Revision rev = pm.createRevision(page, versionLabel, null);
                    revStr = this.getPageRevision(rev, session);
                } else if (res.adaptTo(Asset.class) != null) {
                    Asset asset = (Asset)res.adaptTo(Asset.class);
                    String versionLabel = this.createUniqueVersionLabel(asset.getRevisions(null), this.getAbsTime(workItem));
                    Revision rev = asset.createRevision(versionLabel, null);
                    revStr = this.getAssetRevision(rev, session);
                } else {
                    log.warn("Cannot create version of " + path);
                }
                if (revStr != null) {
                    data.getMetaDataMap().put((Object)"resourceVersion", revStr);
                    if (workItem.getWorkflowData().getMetaDataMap().get("absoluteTime", String.class) != null) {
                        Calendar cal = this.getTime(workItem);
                        data.getMetaDataMap().put((Object)"comment", (Object)("Activate version " + revStr + " on " + cal.getTime().toString()));
                    }
                    workflowSession.updateWorkflowData(workItem.getWorkflow(), data);
                }
            } else {
                log.warn("Cannot process payload. Path is null");
            }
        }
        catch (RepositoryException e) {
            throw new WorkflowException((Throwable)e);
        }
        catch (WCMException e) {
            throw new WorkflowException((Throwable)e);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    private String createUniqueVersionLabel(Collection<?> revisions, String versionLabelHint) throws RepositoryException {
        boolean unique;
        if (versionLabelHint == null) {
            return null;
        }
        LinkedList<Version> versions = new LinkedList<Version>();
        for (Object o : revisions) {
            Object v = o instanceof com.day.cq.wcm.api.Revision ? ((com.day.cq.wcm.api.Revision)o).getVersion() : (o instanceof Revision ? ((Revision)o).getVersion() : null);
            if (null == v) continue;
            versions.add((Version)v);
        }
        String versionLabel = versionLabelHint;
        int count = 1;
        block1: do {
            unique = true;
            for (Version v : versions) {
                if (!v.getContainingHistory().hasVersionLabel(versionLabel)) continue;
                versionLabel = versionLabelHint + " (" + ++count + ")";
                unique = false;
                continue block1;
            }
        } while (!unique);
        return versionLabel;
    }

    private String getPageRevision(com.day.cq.wcm.api.Revision revision, Session session) throws RepositoryException {
        String vid = revision.getId();
        Node v = session.getNodeByIdentifier(vid);
        return v.getName();
    }

    private String getAssetRevision(Revision revision, Session session) throws RepositoryException {
        String vid = revision.getId();
        Node v = session.getNodeByIdentifier(vid);
        return v.getName();
    }

    private String getAbsTime(WorkItem workItem) {
        if (workItem.getWorkflowData().getMetaDataMap().get("absoluteTime", String.class) != null) {
            Calendar cal = this.getTime(workItem);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH.mm.ss");
            return "Scheduled Activation Time is " + formatter.format(cal.getTime());
        }
        return null;
    }

    private Calendar getTime(WorkItem workItem) {
        Long time = (Long)workItem.getWorkflowData().getMetaDataMap().get("absoluteTime", Long.class);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return cal;
    }

    protected void bindJcrResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResolverFactory == jcrResourceResolverFactory) {
            this.jcrResolverFactory = null;
        }
    }
}

