/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs;

import com.day.jcr.vault.fs.api.AccessType;
import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.ExportArtifact;
import com.day.jcr.vault.fs.api.SerializationType;
import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.impl.AbstractArtifact;
import com.day.jcr.vault.fs.io.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.RepositoryException;

public class SerializerArtifact
extends AbstractArtifact
implements ExportArtifact {
    private final Serializer serializer;
    private final long lastModified;

    public SerializerArtifact(Artifact parent, String name, String ext, ArtifactType type, Serializer serializer, long lastModified) {
        super(parent, name, ext, type);
        if (type == ArtifactType.DIRECTORY) {
            throw new IllegalArgumentException("Illegal type 'TYPE_DIRECTORY' for a serialized artifact.");
        }
        this.serializer = serializer;
        this.lastModified = lastModified;
    }

    public AccessType getPreferredAccess() {
        return AccessType.SPOOL;
    }

    public SerializationType getSerializationType() {
        return this.serializer.getType();
    }

    public void spool(OutputStream out) throws IOException, RepositoryException {
        this.serializer.writeContent(out);
    }

    public InputStream getInputStream() throws IOException, RepositoryException {
        return null;
    }

    public VaultInputSource getInputSource() throws IOException, RepositoryException {
        return null;
    }

    public String getContentType() {
        String ct = super.getContentType();
        if (ct == null) {
            ct = this.serializer.getType().getContentType();
        }
        return ct;
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

