/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.config;

import com.day.jcr.vault.fs.api.Aggregator;
import com.day.jcr.vault.fs.api.ArtifactHandler;
import com.day.jcr.vault.fs.impl.aggregator.FileAggregator;
import com.day.jcr.vault.fs.impl.aggregator.FileFolderAggregator;
import com.day.jcr.vault.fs.impl.aggregator.FullCoverageAggregator;
import com.day.jcr.vault.fs.impl.aggregator.GenericAggregator;
import com.day.jcr.vault.fs.impl.aggregator.NodeTypeAggregator;
import com.day.jcr.vault.fs.impl.io.FileArtifactHandler;
import com.day.jcr.vault.fs.impl.io.FolderArtifactHandler;
import com.day.jcr.vault.fs.impl.io.GenericArtifactHandler;
import com.day.jcr.vault.fs.impl.io.NodeTypeArtifactHandler;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry {
    public static Registry instance;
    private final Map<String, Class<? extends Aggregator>> aggregators = new HashMap<String, Class<? extends Aggregator>>();
    private final Map<String, Class<? extends ArtifactHandler>> handlers;

    public static synchronized Registry getInstance() {
        if (instance == null) {
            instance = new Registry();
        }
        return instance;
    }

    private Registry() {
        this.aggregators.put("file", FileAggregator.class);
        this.aggregators.put("full", FullCoverageAggregator.class);
        this.aggregators.put("generic", GenericAggregator.class);
        this.aggregators.put("nodetype", NodeTypeAggregator.class);
        this.aggregators.put("filefolder", FileFolderAggregator.class);
        this.handlers = new HashMap<String, Class<? extends ArtifactHandler>>();
        this.handlers.put("file", FileArtifactHandler.class);
        this.handlers.put("folder", FolderArtifactHandler.class);
        this.handlers.put("nodetype", NodeTypeArtifactHandler.class);
        this.handlers.put("generic", GenericArtifactHandler.class);
    }

    public Class<? extends Aggregator> getAggregatorClass(String type) {
        return this.aggregators.get(type);
    }

    public Class<? extends ArtifactHandler> getHandlerClass(String type) {
        return this.handlers.get(type);
    }

    public Aggregator createAggregator(String type) {
        if (this.aggregators.containsKey(type)) {
            try {
                return this.aggregators.get(type).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create aggregator of type: " + type, e);
            }
        }
        return null;
    }

    public ArtifactHandler createHandler(String type) {
        if (this.handlers.containsKey(type)) {
            try {
                return this.handlers.get(type).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create handler of type: " + type, e);
            }
        }
        return null;
    }
}

