/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.config;

import com.day.jcr.vault.fs.config.AbstractConfig;
import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.config.CredentialsConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VaultAuthConfig
extends AbstractConfig {
    protected static Logger log = LoggerFactory.getLogger(VaultAuthConfig.class);
    public static final String ELEM_REPOSITORY = "repository";
    public static final String ATTR_URI = "uri";
    private final Map<String, RepositoryConfig> repoConfigs = new HashMap<String, RepositoryConfig>();

    protected void doLoad(Element child) throws ConfigurationException {
        if (!child.getNodeName().equals(ELEM_REPOSITORY)) {
            throw new ConfigurationException("unexpected element: " + child.getLocalName());
        }
        RepositoryConfig cfg = RepositoryConfig.load(child);
        if (cfg != null) {
            this.repoConfigs.put(cfg.uri, cfg);
        }
    }

    protected String getRootElemName() {
        return "auth";
    }

    protected double getSupportedVersion() {
        return 1.0;
    }

    public RepositoryConfig getRepoConfig(String uri) {
        return this.repoConfigs.get(uri);
    }

    public void addRepositoryConfig(RepositoryConfig cfg) {
        this.repoConfigs.put(cfg.uri, cfg);
    }

    protected void doWrite(ContentHandler handler) throws SAXException {
        for (RepositoryConfig cfg : this.repoConfigs.values()) {
            cfg.write(handler);
        }
    }

    public boolean load() throws IOException, ConfigurationException {
        return this.load(new File(this.getConfigDir(), "auth.xml"));
    }

    public void save() throws IOException {
        this.save(new File(this.getConfigDir(), "auth.xml"));
    }

    public static class RepositoryConfig {
        public final String uri;
        public CredentialsConfig creds;

        public RepositoryConfig(String uri) {
            this.uri = uri;
        }

        public CredentialsConfig getCredsConfig() {
            return this.creds;
        }

        public void addCredsConfig(CredentialsConfig creds) {
            this.creds = creds;
        }

        public static RepositoryConfig load(Element elem) throws ConfigurationException {
            assert (elem.getNodeName().equals(VaultAuthConfig.ELEM_REPOSITORY));
            String uri = elem.getAttribute(VaultAuthConfig.ATTR_URI);
            if (uri == null) {
                throw new ConfigurationException("missing attribute: uri");
            }
            RepositoryConfig cfg = new RepositoryConfig(uri);
            NodeList nl = elem.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                if (child.getNodeName().equals("credentials")) {
                    CredentialsConfig ccfg = CredentialsConfig.load((Element)child);
                    if (ccfg == null) continue;
                    cfg.creds = ccfg;
                    continue;
                }
                throw new ConfigurationException("unexpected element: " + child.getLocalName());
            }
            return cfg;
        }

        public void write(ContentHandler handler) throws SAXException {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", VaultAuthConfig.ATTR_URI, "", "CDATA", this.uri);
            handler.startElement("", VaultAuthConfig.ELEM_REPOSITORY, "", attrs);
            this.creds.write(handler);
            handler.endElement("", VaultAuthConfig.ELEM_REPOSITORY, "");
        }
    }
}

