/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.config;

import com.day.jcr.vault.fs.api.Filter;
import com.day.jcr.vault.fs.api.ItemFilter;
import com.day.jcr.vault.fs.api.ItemFilterSet;
import com.day.jcr.vault.fs.config.AbstractVaultFsConfig;
import com.day.jcr.vault.fs.config.ConfigHelper;
import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.config.VaultFsConfig11;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class VaultFsConfig10
extends AbstractVaultFsConfig {
    private static final Logger log = LoggerFactory.getLogger(VaultFsConfig11.class);
    public static final double SUPPORTED_VERSION = 1.0;
    private final ConfigHelper helper = new ConfigHelper();

    VaultFsConfig10() {
        Map<String, String> m = this.helper.getMappings();
        m.put("com.day.jcr.vault.fs.imprt.NtFileArtifactHandler", "com.day.jcr.vault.fs.impl.io.FileArtifactHandler");
        m.put("com.day.jcr.vault.fs.imprt.FolderArtifactHandler", "com.day.jcr.vault.fs.impl.io.FileArtifactHandler");
        m.put("com.day.jcr.vault.fs.imprt.FileArtifactHandler", "com.day.jcr.vault.fs.impl.io.FileArtifactHandler");
        m.put("com.day.jcr.vault.fs.imprt.GenericArtifactHandler", "com.day.jcr.vault.fs.impl.io.GenericArtifactHandler");
        m.put("com.day.jcr.vault.fs.imprt.NodeTypeArtifactHandler", "com.day.jcr.vault.fs.impl.io.NodeTypeArtifactHandler");
        m.put("com.day.jcr.vault.fs.aggregator.FileAggregator", "com.day.jcr.vault.fs.impl.aggregator.FileAggregator");
        m.put("com.day.jcr.vault.fs.aggregator.FileFolderAggregator", "com.day.jcr.vault.fs.impl.aggregator.FileFolderAggregator");
        m.put("com.day.jcr.vault.fs.aggregator.GenericAggregator", "com.day.jcr.vault.fs.impl.aggregator.GenericAggregator");
        m.put("com.day.jcr.vault.fs.aggregator.NodeTypeAggregator", "com.day.jcr.vault.fs.impl.aggregator.NodeTypeAggregator");
        m.put("com.day.jcr.vault.fs.aggregator.FullCoverageAggregator", "com.day.jcr.vault.fs.impl.aggregator.FullCoverageAggregator");
        m.put("com.day.jcr.vault.fs.filter.ItemFilter", "com.day.jcr.vault.fs.api.ItemFilter");
        m.put("com.day.jcr.vault.fs.filter.PathFilter", "com.day.jcr.vault.fs.api.PathFilter");
    }

    public Map getDefaultPackages() {
        return this.helper.getDefaultPackages();
    }

    public Map getDefaultClasses() {
        return this.helper.getDefaultClasses();
    }

    protected void process(Element doc) throws ConfigurationException {
        doc.getAttributes().removeNamedItem("version");
        this.process(this, doc);
    }

    private void process(Object obj, Element elem) throws ConfigurationException {
        try {
            log.debug("Processing <{}> on {}", (Object)elem.getNodeName(), obj);
            NamedNodeMap attrs = elem.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                ConfigHelper.setField(obj, attr.getName(), attr.getValue());
            }
            NodeList nl = elem.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                Object o = ConfigHelper.invokeGetter(obj, child.getNodeName(), Object.class);
                if (obj instanceof List) {
                    if (o == null) {
                        o = this.helper.create((Element)child);
                    }
                    ((List)obj).add(o);
                } else if (obj instanceof Map) {
                    if (o == null) {
                        o = this.helper.create((Element)child);
                    }
                    ((Map)obj).put(child.getNodeName(), o);
                } else if (obj instanceof ItemFilterSet) {
                    ItemFilterSet filter = (ItemFilterSet)obj;
                    if (o == null) {
                        o = this.helper.create((Element)child);
                    }
                    if (child.getNodeName().equals("include")) {
                        filter.addInclude((Filter)((ItemFilter)o));
                    } else if (child.getNodeName().equals("exclude")) {
                        filter.addExclude((Filter)((ItemFilter)o));
                    } else {
                        this.fail("Element " + child + " not expected here", elem);
                    }
                } else if (ConfigHelper.hasSetter(obj, child.getNodeName())) {
                    if (o == null) {
                        o = this.helper.create((Element)child);
                    }
                    ConfigHelper.setField(obj, child.getNodeName(), o);
                } else if (o == null) {
                    this.fail("Unable to handle " + child.getNodeName() + " on " + obj, elem);
                }
                this.process(o, (Element)child);
            }
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            this.fail("Error while processing: " + e, elem);
        }
    }
}

