/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.filter;

import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.ItemFilter;
import javax.jcr.Item;
import javax.jcr.RepositoryException;

public class DepthItemFilter
implements ItemFilter {
    private int minDepth = 0;
    private int maxDepth = Integer.MAX_VALUE;

    public DepthItemFilter() {
    }

    public DepthItemFilter(int minDepth, int maxDepth) {
        this.minDepth = minDepth;
        this.maxDepth = maxDepth;
    }

    public void setMinDepth(String minDepth) {
        this.minDepth = Integer.decode(minDepth);
    }

    public void setMaxDepth(String maxDepth) {
        this.maxDepth = Integer.decode(maxDepth);
    }

    public boolean matches(Item item, int depth) throws RepositoryException {
        return depth >= this.minDepth && depth <= this.maxDepth && this.matches(item);
    }

    public boolean matches(Item item) throws RepositoryException {
        return true;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.printf(isLast, "%s:", new Object[]{this.getClass().getSimpleName()});
        ctx.indent(isLast);
        ctx.printf(false, "minDepth: %d", new Object[]{this.minDepth});
        ctx.printf(true, "maxDepth: %d", new Object[]{this.maxDepth});
        ctx.outdent();
    }
}

