/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.filter;

import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.filter.DepthItemFilter;
import javax.jcr.Item;
import javax.jcr.RepositoryException;

public class IsNodeFilter
extends DepthItemFilter {
    private boolean isNode = true;

    public IsNodeFilter() {
        super(1, Integer.MAX_VALUE);
    }

    public IsNodeFilter(boolean polarity, int minDepth, int maxDepth) {
        super(minDepth, maxDepth);
        this.isNode = polarity;
    }

    public IsNodeFilter(boolean polarity) {
        this(polarity, 1, Integer.MAX_VALUE);
    }

    public void setPolarity(String polarity) {
        this.setIsNode(polarity);
    }

    public void setIsNode(String polarity) {
        this.isNode = Boolean.valueOf(polarity);
    }

    public boolean matches(Item item) throws RepositoryException {
        return item.isNode() == this.isNode;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        super.dump(ctx, isLast);
        ctx.indent(isLast);
        ctx.printf(true, "isNode: %b", new Object[]{this.isNode});
        ctx.outdent();
    }
}

